#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import AsuPStore
import Tac

class SandFapAsuPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   def __init__( self, sandStatus=None, phyStatusDir=None ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.sandStatus = sandStatus
      self.phyStatusDir = phyStatusDir

   def getSupportedKeys( self ):
      return [ 'systemPhyPortId', 'autonegIntfs' ]

   def getKeys( self ):
      return [ 'systemPhyPortId', 'autonegIntfs' ]

   def getSystemPhyPortIdInfo( self ):
      isSubIntfId = Tac.Type( 'Arnet::SubIntfId' ).isSubIntfId
      interfaces = {
         intfName : sppid for intfName, sppid in
         self.sandStatus.systemPhyPortId.items()
         if intfName.startswith( 'Ethernet' ) and not isSubIntfId( intfName )
      }
      return interfaces

   def getAutonegInfo( self ):
      try:
         aradPhyStatusDir = self.phyStatusDir[ 'FixedSystem' ][ 'SandFap' ]
      except KeyError:
         return {}
      phyStatusCol = aradPhyStatusDir.phyStatus
      return {
         name : phyStatus.operSpeed for name, phyStatus in
         phyStatusCol.items() if phyStatus.autonegEnabled
      }

   def save( self, pStoreIO ):
      pStoreIO.set( 'systemPhyPortId', self.getSystemPhyPortIdInfo() )
      pStoreIO.set( 'autonegIntfs', self.getAutonegInfo() )


def Plugin( ctx ):
   featureName = 'SandFap'

   if ctx.opcode() == 'GetSupportedKeys':
      eventHandler = SandFapAsuPStoreEventHandler()
   else:
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()

      sandStatus = mg.mount( 'hardware/sand/system/status/sand',
                             'Hardware::Sand::Status', 'r' )
      phyStatusDir = mg.mount( 'hardware/phy/status/arad/slice',
                               'Tac::Dir', 'ri' )

      mg.close( blocking=True )
      eventHandler = SandFapAsuPStoreEventHandler( sandStatus, phyStatusDir )

   ctx.registerAsuPStoreEventHandler( featureName, eventHandler )
