#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# N.B. If you edit this file you must regenerate and replace
# the associated AsuPatch patch RPM. For more information see
# /src/AsuPatch/packages/README.

import AsuPStore

class StrataL3PStoreEventHandler( AsuPStore.PStoreEventHandler ):

   def __init__( self, vpReferenceList ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.vpReferenceList_ = vpReferenceList

   def _remoteVport( self ):
      remoteVport = {}
      if self.vpReferenceList_.remoteVport:
         for remoteVtepKey in self.vpReferenceList_.remoteVport:
            vpRef = self.vpReferenceList_.remoteVport[ remoteVtepKey ]
            vp = vpRef.vPort

            intVpType = 1 if remoteVtepKey.vpType == 'vp' else 2
            if callable( remoteVtepKey.vtepIp ):
               ix = remoteVtepKey.vtepIp().v4Addr()
            else:
               # older releases have this as an attribute, not a function
               ix = remoteVtepKey.vtepIp.v4Addr
            remoteVport[ vp.vpIndex ] = [ intVpType,
                                          remoteVtepKey.swTunnelGroupId.index,
                                          ix ]

      return remoteVport

   def _edgeVport( self ):
      edgeVport = {}
      if self.vpReferenceList_.edgeVport:
         for portVlanKey in self.vpReferenceList_.edgeVport:
            vpRef = self.vpReferenceList_.edgeVport[ portVlanKey ]
            vp = vpRef.vPort

            edgeVport[ vp.vpIndex ] = [ portVlanKey.portId, portVlanKey.vlanId,
                                        portVlanKey.innerVlanId ]

      return edgeVport

   def _vlanVport( self ):
      vlanVport = {}
      if self.vpReferenceList_.vlanVport:
         for vlanId in self.vpReferenceList_.vlanVport:
            vpRef = self.vpReferenceList_.vlanVport[ vlanId ]
            vp = vpRef.vPort
            vlanVport[ vp.vpIndex ] = vlanId

      return vlanVport

   def _mlagRemoteVport( self ):
      mlagRemoteVport = {}
      if hasattr( self.vpReferenceList_, 'mlagRemoteVport' ) and \
            self.vpReferenceList_.mlagRemoteVport:
         for remoteVtepKey in self.vpReferenceList_.mlagRemoteVport:
            vpRef = self.vpReferenceList_.mlagRemoteVport[ remoteVtepKey ]
            vp = vpRef.vPort

            # vp type 3 for mlag vp
            intVpType = 3 
            if callable( remoteVtepKey.vtepIp ):
               ix = remoteVtepKey.vtepIp().v4Addr()
            else:
               # older releases have this as an attribute, not a function
               ix = remoteVtepKey.vtepIp.v4Addr
            mlagRemoteVport[ vp.vpIndex ] = [ intVpType,
                                              remoteVtepKey.swTunnelGroupId.index,
                                              ix ]

      return mlagRemoteVport

   def save( self, pStoreIO ):
      pStoreData = {}
      pStoreData[ 'remoteVport' ] = self._remoteVport()
      pStoreData[ 'edgeVport' ] = self._edgeVport()
      pStoreData[ 'vlanVport' ] = self._vlanVport()
      pStoreData[ 'mlagRemoteVport' ] = self._mlagRemoteVport()
      pStoreIO.set( "vpReferenceList", pStoreData )

   def getSupportedKeys( self ):
      return [ 'vpReferenceList' ]

   def getKeys( self ):
      return [ 'vpReferenceList' ]

def Plugin( ctx ):
   featureName = "StrataL3"

   if ctx.opcode() == 'GetSupportedKeys':
      ctx.registerAsuPStoreEventHandler(
         featureName, StrataL3PStoreEventHandler( None ) )
      return

   entityManager = ctx.entityManager()
   mg = entityManager.mountGroup()

   vpReferenceList = mg.mount( "hardware/strata/vp/reference", 
                               "StrataCentral::VpReferenceList", "ri" )

   mg.close( blocking=True )
   ctx.registerAsuPStoreEventHandler(
      featureName, StrataL3PStoreEventHandler( vpReferenceList ) )
