# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PropertyInfo(Model):
    """Information about a Service Fabric property.

    :param name: The name of the Service Fabric property.
    :type name: str
    :param value: Describes a Service Fabric property value.
    :type value: ~azure.servicefabric.models.PropertyValue
    :param metadata: The metadata associated with a property, including the
     property's name.
    :type metadata: ~azure.servicefabric.models.PropertyMetadata
    """

    _validation = {
        'name': {'required': True},
        'metadata': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'PropertyValue'},
        'metadata': {'key': 'Metadata', 'type': 'PropertyMetadata'},
    }

    def __init__(self, name, metadata, value=None):
        super(PropertyInfo, self).__init__()
        self.name = name
        self.value = value
        self.metadata = metadata
