# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DeployedServiceTypeInfo(Model):
    """Information about service type deployed on a node, information such as the
    status of the service type registration on a node.

    :param service_type_name: Name of the service type as specified in the
     service manifest.
    :type service_type_name: str
    :param service_manifest_name: The name of the service manifest in which
     this service type is defined.
    :type service_manifest_name: str
    :param code_package_name: The name of the code package that registered the
     service type.
    :type code_package_name: str
    :param status: The status of the service type registration on the node.
     Possible values include: 'Invalid', 'Disabled', 'Enabled', 'Registered'
    :type status: str or
     ~azure.servicefabric.models.ServiceTypeRegistrationStatus
    :param service_package_activation_id: The ActivationId of a deployed
     service package. If ServicePackageActivationMode specified at the time of
     creating the service
     is 'SharedProcess' (or if it is not specified, in which case it defaults
     to 'SharedProcess'), then value of ServicePackageActivationId
     is always an empty string.
    :type service_package_activation_id: str
    """

    _attribute_map = {
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'code_package_name': {'key': 'CodePackageName', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
    }

    def __init__(self, service_type_name=None, service_manifest_name=None, code_package_name=None, status=None, service_package_activation_id=None):
        super(DeployedServiceTypeInfo, self).__init__()
        self.service_type_name = service_type_name
        self.service_manifest_name = service_manifest_name
        self.code_package_name = code_package_name
        self.status = status
        self.service_package_activation_id = service_package_activation_id
