# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AadMetadata(Model):
    """Azure Active Directory metadata used for secured connection to cluster.

    :param authority: The AAD authority url.
    :type authority: str
    :param client: The AAD client application Id.
    :type client: str
    :param cluster: The AAD cluster application Id.
    :type cluster: str
    :param login: The AAD login url.
    :type login: str
    :param redirect: The client application redirect address.
    :type redirect: str
    :param tenant: The AAD tenant Id.
    :type tenant: str
    """

    _attribute_map = {
        'authority': {'key': 'authority', 'type': 'str'},
        'client': {'key': 'client', 'type': 'str'},
        'cluster': {'key': 'cluster', 'type': 'str'},
        'login': {'key': 'login', 'type': 'str'},
        'redirect': {'key': 'redirect', 'type': 'str'},
        'tenant': {'key': 'tenant', 'type': 'str'},
    }

    def __init__(self, authority=None, client=None, cluster=None, login=None, redirect=None, tenant=None):
        super(AadMetadata, self).__init__()
        self.authority = authority
        self.client = client
        self.cluster = cluster
        self.login = login
        self.redirect = redirect
        self.tenant = tenant
