# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class Rule(Resource):
    """Description of Rule Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param action: Represents the filter actions which are allowed for the
     transformation of a message that have been matched by a filter expression.
    :type action: ~azure.mgmt.servicebus.models.Action
    :param filter_type: Filter type that is evaluated against a
     BrokeredMessage. Possible values include: 'SqlFilter', 'CorrelationFilter'
    :type filter_type: str or ~azure.mgmt.servicebus.models.FilterType
    :param sql_filter: Properties of sqlFilter
    :type sql_filter: ~azure.mgmt.servicebus.models.SqlFilter
    :param correlation_filter: Properties of correlationFilter
    :type correlation_filter: ~azure.mgmt.servicebus.models.CorrelationFilter
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'action': {'key': 'properties.action', 'type': 'Action'},
        'filter_type': {'key': 'properties.filterType', 'type': 'FilterType'},
        'sql_filter': {'key': 'properties.sqlFilter', 'type': 'SqlFilter'},
        'correlation_filter': {'key': 'properties.correlationFilter', 'type': 'CorrelationFilter'},
    }

    def __init__(self, action=None, filter_type=None, sql_filter=None, correlation_filter=None):
        super(Rule, self).__init__()
        self.action = action
        self.filter_type = filter_type
        self.sql_filter = sql_filter
        self.correlation_filter = correlation_filter
