# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CoreSummary(Model):
    """The core summary of a search.

    :param status: The status of a core summary.
    :type status: str
    :param number_of_documents: The number of documents of a core summary.
    :type number_of_documents: long
    """

    _validation = {
        'number_of_documents': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'str'},
        'number_of_documents': {'key': 'NumberOfDocuments', 'type': 'long'},
    }

    def __init__(self, number_of_documents, status=None):
        self.status = status
        self.number_of_documents = number_of_documents
