# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ContainerServiceServicePrincipalProfile(Model):
    """Information about a service principal identity for the cluster to use for
    manipulating Azure APIs. Either secret or keyVaultSecretRef must be
    specified.

    :param client_id: The ID for the service principal.
    :type client_id: str
    :param secret: The secret password associated with the service principal
     in plain text.
    :type secret: str
    :param key_vault_secret_ref: Reference to a secret stored in Azure Key
     Vault.
    :type key_vault_secret_ref:
     ~azure.mgmt.containerservice.models.KeyVaultSecretRef
    """

    _validation = {
        'client_id': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
        'key_vault_secret_ref': {'key': 'keyVaultSecretRef', 'type': 'KeyVaultSecretRef'},
    }

    def __init__(self, client_id, secret=None, key_vault_secret_ref=None):
        super(ContainerServiceServicePrincipalProfile, self).__init__()
        self.client_id = client_id
        self.secret = secret
        self.key_vault_secret_ref = key_vault_secret_ref
