# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GitRepoVolume(Model):
    """Represents a volume that is populated with the contents of a git
    repository.

    :param directory: Target directory name. Must not contain or start with
     '..'.  If '.' is supplied, the volume directory will be the git
     repository.  Otherwise, if specified, the volume will contain the git
     repository in the subdirectory with the given name.
    :type directory: str
    :param repository: Repository URL
    :type repository: str
    :param revision: Commit hash for the specified revision.
    :type revision: str
    """

    _validation = {
        'repository': {'required': True},
    }

    _attribute_map = {
        'directory': {'key': 'directory', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'revision': {'key': 'revision', 'type': 'str'},
    }

    def __init__(self, repository, directory=None, revision=None):
        super(GitRepoVolume, self).__init__()
        self.directory = directory
        self.repository = repository
        self.revision = revision
