# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ContainerPropertiesInstanceView(Model):
    """The instance view of the container instance. Only valid in response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar restart_count: The number of times that the container instance has
     been restarted.
    :vartype restart_count: int
    :ivar current_state: Current container instance state.
    :vartype current_state:
     ~azure.mgmt.containerinstance.models.ContainerState
    :ivar previous_state: Previous container instance state.
    :vartype previous_state:
     ~azure.mgmt.containerinstance.models.ContainerState
    :ivar events: The events of the container instance.
    :vartype events: list[~azure.mgmt.containerinstance.models.Event]
    """

    _validation = {
        'restart_count': {'readonly': True},
        'current_state': {'readonly': True},
        'previous_state': {'readonly': True},
        'events': {'readonly': True},
    }

    _attribute_map = {
        'restart_count': {'key': 'restartCount', 'type': 'int'},
        'current_state': {'key': 'currentState', 'type': 'ContainerState'},
        'previous_state': {'key': 'previousState', 'type': 'ContainerState'},
        'events': {'key': 'events', 'type': '[Event]'},
    }

    def __init__(self):
        super(ContainerPropertiesInstanceView, self).__init__()
        self.restart_count = None
        self.current_state = None
        self.previous_state = None
        self.events = None
