# Releases

The ```release/``` directory contains published OpenConfig models, documentation, and other material for the community.

## Models

Published versions of OpenConfig modules can be found in the ```release/models``` directory. The current released model set is:

 * `bgp` - covering configuration and state relating to Border Gateway Protocol (BGP), including multi-protocol extensions. The `openconfig-bgp-policy` module provides augmentations to the OpenConfig routing policy framework to allow policies to utilise BGP-specific routing attributes.
 * `interfaces` - which provides configuration and state for physical and logical device interfaces and associated IP addressing. Extension modules provide configuration for aggregate interfaces (`openconfig-if-aggregate`) and Ethernet-specific interface parameters (`openconfig-if-ethernet`).
 * `local-routing` - allowing interaction with the configuration and operational state relating to static and aggregate routes which are generated by a device locally.
 * `mpls` - comprehensive data model for configuration and operational
 state of MPLS/TE, including signaling protocols such as RSVP, LDP, and
 segment routing.
 * `optical-transport` - providing a configuration and state model for terminal optical devices within a DWDM system, including both client- and line-side parameters.
 * `policy` - a framework for routing policies to be expressed allowing matching of particular routing elements or sets, and actions to be performed on them. Other models may augment this model to add protocol-specific types, and reference policies defined within it.
 * `rib` - a data model representing the BGP-4 routing information base (RIB) contents. Extensions to the 'base' RIB model adding additional data elements of operational use are defined in `openconfig-rib-bgp-ext`.
 * `telemetry` - describing state and configuration parameters relating to a device's ability to stream telemetry information to a network management system.
 * `vlan` - a model allowing the configuration and state retrieval of parameters corresponding to 802.1Q VLANs on a device - including the creation of routed interfaces corresponding to those VLANs.
 * `network-instance` - a model defining configuration and operational state parameters for a Layer 2 or Layer 3 forwarding instance on a network element.
 * `rpc` - defines the set of operations that are expected between a network element and a device supporting OpenConfig models.

Generic type definitions which OpenConfig utilises can be found in the `openconfig-types` module.

OpenConfig YANG extensions are in the `openconfig-extensions` module.
