function sampleScript1(){ 
// This script prints out the switch's MAC address

// Create an EapiClient object...
var eapi = new EapiClient();
// and form the eAPI request:
var request = eapi.runCmds({'version': 1, 'cmds': ['show version']});

request.done(function(result){
   // Hooray, the switch replied with data! Since we sent 1 command,
   // the data we care about is at result[0]. Extract the MAC address
   // and print it to the console:
   var macAddr = result[0]["systemMacAddress"];
   logMessage("The switch's system MAC addess is " + macAddr);
});
}

function sampleScript2() {
// This script prints all interfaces that have been using at least 10% of their transmit bandwidth

var eapi = new EapiClient();
var request = eapi.runCmds({'version': 1,
                            'cmds': ['enable', 'show interfaces counters rates']});
request.done(function(result) {
   var interfaces = result[0].interfaces;
   logMessage( "The following interfaces have been sending traffic:" );
   logMessage( "---------------------------------------------------" );
   var anyBusyIntfs = false;
   for (var intfName in interfaces) {
      var intf = interfaces[intfName];
      if (intf.outPpsRate && intf.outPpsRate > 0.1) {
         var rate = Math.round(intf.outPpsRate * 100);
         logMessage(intfName, intf.description, "is using " + rate + "% of its bandwidth");
         anyBusyIntfs = true;
      }
   }
   if (!anyBusyIntfs) {
      logMessage("No interfaces were busy!");
   }
});
}

function sampleScript3() {
// This script shows all ACLs on the switch. We just use the default "text" formatting.

var eapi = new EapiClient();
var request = eapi.runCmds(
    {'version': 1,
     'cmds': [
         {cmd: "enable", input: ""}, // You can enter an enable password in the "input"
         'show ip access-lists',
     ],
     'format': 'text'});

request.done(function(data) {
   logMessage(data[1].output);
});
}


function sampleScript4() {
// This configures an IP access control list (ACL) on the switch with
// the name "eapiExample" (that permits all traffic).
var commandsToRun = [
   {cmd: "enable", input: ""}, // You can enter an enable password in the "input"
   "configure",
   "ip access-list eapiExample",
   "10 permit ip any any",
];

var eapi = new EapiClient();
var request = eapi.runCmds({'version': 1, 'cmds': commandsToRun, 'timestamps': true});
request.done(function(data) {
   logMessage("ACL eapiExample created. Run the 'Show configured ACLs' script to see it!");
});
request.fail(function(code, message, data) {
   logMessage("ACL eapiExample could not be created!");
});
}

function sampleScript5() {
// This removes the IP access control list (ACL) named "eapiExample".
var commandsToRun = [
   {cmd: "enable", input: ""}, // You can enter an enable password in the "input"
   "configure",
   "no ip access-list eapiExample",
];

var eapi = new EapiClient();
var request = eapi.runCmds({'version': 1, 'cmds': commandsToRun, 'timestamps': true});
request.done(function(data) {
   logMessage("ACL eapiExample removed");
});
}

SAMPLE_SCRIPTS = [ { "scriptName": "Print switch address", "script": sampleScript1 },
                   { "scriptName": "Show active intfs", "script": sampleScript2 },
                   { "scriptName": "Show configured ACLs", "script": sampleScript3 },
                   { "scriptName": "Create example ACL", "script": sampleScript4 },
                   { "scriptName": "Remove example ACL", "script": sampleScript5 },
                 ];
