#!/bin/bash

# in cEOS all the psp's are stored in /usr/share/psp
find_psp_in_ceos() {
   for plugin in /usr/share/GenPspPlugin/*.sh; do
      pspMatch="$(bash $plugin $1)"
      if [ "${pspMatch}" ]; then
         # Parse the output of each PSP plugin to get the PSP file name.
         # When passing the ONIE platform name to the plugin, the PSP file name
         # will be echoed back in the form of "ONIE_PLATFORM PSP_FILE_NAME".
         pspName=$(echo $pspMatch | cut -d" " -f2)
         echo "/usr/share/psp/${pspName}"
         return
      fi
   done
}

install_psp() {
   unzip -d /tmp $1 &> /dev/null
   eos_version=$( awk '{ print $4 }' /etc/Eos-release )

   version=$( /usr/bin/PspInit.py --pspRoot /tmp/psp --eosVersion $eos_version )
   if [ $? != 0 ]; then
      version=""
   fi

   if [ -n "$version" ]; then
      # The PSP has support for our version, install it. We do this the hard way to
      # allow the PSP RPMs to overwrite files from already installed RPMs without
      # error. This is necessary to allow arbitrary overriding.
      #
      # All dependencies must come from the PSP because there are no other RPM
      # sources to use at the time.
      requiredRpms=""
      for rpm in /tmp/psp/shared/*.rpm; do
         requiredRpms+="$rpm "
      done
      echo $requiredRpms > /tmp/driverdeps
      shopt -s nullglob
      rpm -i --replacefiles /tmp/psp/$version/drivers.rpm $requiredRpms
      shopt -u nullglob

      # Install modules listed in /tmp/psp/modules.list
      if [ -f "/tmp/psp/modules.list" ]; then
         while read module; do
            modprobe "$module"
         done </tmp/psp/modules.list
      fi

   else
      echo "No version contained in the PSP matches EOS $eos_version"
   fi

   rm -rf /tmp/psp
}

select_and_install_psp() {
   local onie_platform=
   local psp=

   [ -f /etc/onie_platform ] && onie_platform=$( cat /etc/onie_platform )

   source /usr/share/CEos/CEosHelper.sh

      # We store all the psp's in cEOS under /usr/share/psp.
   if [ -n "$onie_platform" ] && is_ceos; then
      psp=$( find_psp_in_ceos $onie_platform )
   # Find the PSP, if any, and install the PSP RPM(s)
   # If a PSP was found inside the swi, Aboot will publish it to /mnt/flash/.boot.psp
   elif [ -f "/mnt/flash/.boot.psp" ]; then
      psp="/mnt/flash/.boot.psp"
   elif [ -f "/mnt/flash/Drivers.psp" ]; then
      psp="/mnt/flash/Drivers.psp"
   elif [ -f "/mnt/flash/.Drivers.psp" ]; then
      psp="/mnt/flash/.Drivers.psp"
   fi

   [ -z "$psp" ] && return

   install_psp "$psp"
}
