#!/bin/bash

# Fix for BUG186906
umount_ceos_files() {
   umount /etc/hosts
   umount /etc/hostname
   umount /etc/resolv.conf
}

is_ceos() {
   if [ "$A4_CHROOT" ]; then
      if [ "$CEOS" ]; then
         return 0
      else
         return 1
      fi
   else
      if [ -f "/etc/cEOS-release" ] || [ "$CEOS" ]; then
         return 0
      else
         return 1
      fi
   fi
}

# In cEOS we volume mount /dev:/hostdev. If we modprobe ipmi_devintf, the ipmi
# device will appear in /hostdev. To get around this, create a symlink for any
# ipmi device.
install_host_devices() {
   if is_ceos; then
      for hostDevPath in /hostdev/*ipmi*; do
         [ -e "$hostDevPath" ] || continue
         device=$(basename $hostDevPath)
         [ -e "/dev/$device" ] || ln -s "$hostDevPath" "/dev/$device"
      done
   fi
}

ceos_sysinit() {
   if ! is_ceos; then
      return 0
   fi

   umount_ceos_files

   # Also link the consoles for cEOS and the host
   # Since we stopped the login services in cEOS
   if [ ! -c /dev/console ]; then
      ln -s /hostdev/console /dev/console
   fi
   # By default /dev/dmamem doesn't exist in the container, as host devices are
   # mapped to /hostdev/ in the container. Create a symlink for /dev/dmamem.
   if [ ! -c /dev/dmamem ]; then
      ln -s /hostdev/dmamem /dev/dmamem
   fi

   install_host_devices
}
