# Based on include/linux/if_packet.h.

# Packet types

PACKET_HOST      = 0    # To us
PACKET_BROADCAST = 1    # To all
PACKET_MULTICAST = 2    # To group
PACKET_OTHERHOST = 3    # To someone else
PACKET_OUTGOING  = 4    # Outgoing of any type
# These ones are invisible by user level
PACKET_LOOPBACK  = 5    # MC/BRD frame looped back
PACKET_FASTROUTE = 6    # Fastrouted frame

# Packet socket options

PACKET_ADD_MEMBERSHIP     = 1
PACKET_DROP_MEMBERSHIP    = 2
PACKET_RECV_OUTPUT        = 3
# Value 4 is still used by obsolete turbo-packet.
PACKET_RX_RING            = 5
PACKET_STATISTICS         = 6
PACKET_COPY_THRESH        = 7
PACKET_AUXDATA            = 8
PACKET_ORIGDEV            = 9
PACKET_VERSION            = 10
PACKET_HDRLEN             = 11
PACKET_RESERVE            = 12
PACKET_TX_RING            = 13
PACKET_LOSS               = 14
PACKET_VNET_HDR           = 15
PACKET_TX_TIMESTAMP       = 16
PACKET_TIMESTAMP          = 17
PACKET_FANOUT             = 18

PACKET_FANOUT_HASH        = 0
PACKET_FANOUT_LB          = 1
PACKET_FANOUT_CPU         = 2
PACKET_FANOUT_FLAG_DEFRAG = 0x8000

# Rx ring - header status
TP_STATUS_KERNEL          = 0x0
TP_STATUS_USER            = 0x1
TP_STATUS_COPY            = 0x2
TP_STATUS_LOSING          = 0x4
TP_STATUS_CSUMNOTREADY    = 0x8
TP_STATUS_VLAN_VALID      = 0x10 # auxdata has valid tp_vlan_tci
TP_STATUS_BLK_TMO         = 0x20
TP_STATUS_VLAN_TPID_VALID = 0x40 # auxdata has valid tp_vlan_tpid

# Tx ring - header status
TP_STATUS_AVAILABLE     = 0x0
TP_STATUS_SEND_REQUEST  = 0x1
TP_STATUS_SENDING       = 0x2
TP_STATUS_WRONG_FORMAT  = 0x4

# Based on include/linux/socket.h.

SOL_PACKET = 263
