#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

def entityManager( sysname=None, local=None, sysdbEm=None ):
   if sysdbEm:
      # The should supply *either* a sysdbEm object *or* a sysname/local pair.
      assert sysname is None
      assert local is None
      sysname = sysdbEm.sysname()
      local = sysdbEm.local()
   return Tac.Type( 'TacSharedMem::EntityManager' ).getEntityManager( sysname,
                                                                      local )
#
# Wrapper for CliMountGroup, which is a variant of MountGroup with auto-unmounting.
#
class CliMountGroup( object ):
   def __init__( self, shmemEm=None, sysdbEm=None ):
      self.shmemEm_ = None
      if shmemEm:
         assert not sysdbEm
         self.shmemEm_ = shmemEm
      else:
         assert sysdbEm
         self.shmemEm_ = entityManager( sysdbEm=sysdbEm )
      self.cMg_ = self.shmemEm_.getCliMountGroup()

   def doMount( self, entityPath, entityType, mountInfo ):
      return self.cMg_.doMount( entityPath, entityType, mountInfo )

   def doClose( self, blocking=False, timeout=600 ):
      self.cMg_.doClose()
      # When blocking=True, wait until the mount group is stable, i.e. until
      # all pending syncs have completed. This will *not* block waiting for
      # collections to appear in shared-memory, it will just make sure that
      # all currently attached collections are fully synced when returning.
      if blocking and not self.cMg_.stable:
         Tac.waitFor( lambda: self.cMg_.stable, sleep=True, timeout=timeout,
                      description='CliMountGroup to be stable' )

def cohabMultithreadMounts():
   return Tac.Type( 'TacSharedMem::EntityManager' ).cohabMultithreadMounts()

def cohabMultithreadMountsIs( cmm ):
   return Tac.Type( 'TacSharedMem::EntityManager' ).cohabMultithreadMountsIs( cmm )
