#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from __future__ import absolute_import, division, print_function
import six

class FilteredDictView( object ):
   # This is a helper class that provides a filtered view of an existing
   # dictionary. filterFn is a filter function that returns whether each key
   # in the dictionary is valid. This is often more efficient than generating
   # a new dictionary.
   def __init__( self, dictionary, filterFn ):
      self.dict_ = dictionary
      self.filter_ = filterFn
      self.iter_ = None
   def __getitem__( self, key ):
      if not self.filter_( key ):
         raise KeyError
      return self.dict_[ key ]
   def keys( self ):
      return [ k for k in self.dict_ if self.filter_( k ) ]
   def __contains__( self, k ):
      return k in self.dict_ and self.filter_( k )
   def __iter__( self ):
      return six.moves.filter( self.filter_, self.dict_ )
