# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import eossdk


def CustomCli(cliName):
   """ For custom CLI, user defines Plugin(sdk) function which is invoked
      by CLI infra, but the 'sdk' is actually 'entityManager', which is being
      replaced here by real 'sdk'.
      @CustomCli("myAgentName") needs to be placed before user's Plugin(sdk)
      as a decorator. """
   def newPlugin(plugin):
      def newPlugin_f(*args):
         entityManager = args[0]
         sdk = eossdk.Sdk(cliName, Tac.addressOf(entityManager.cEntityManager()))
         plugin(sdk)
         sdk.initialize_context()
      return newPlugin_f

   return newPlugin
