# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import ShowCommand
import CliMatcher
import IpAddrMatcher

from DaemonCli import DaemonCliMode

# "click" here to jump to Cli_Command_Definitions (at the bottom of file)
# ############################################################################
# ################# Cli_Command_Handlers #####################################
# ############################################################################


def doRouteShow(self, args):
   import eossdk
   tag = args.get('TAG_NUM', 0)
   numRoutes = 0
   totalRoutes = 0
   lock = eossdk.SdkScopedLock()
   routeFmt = "{} [preference {}, tag {}] has nexthops:"
   for route in self.ipRouteMgr.ip_route_iter():
      totalRoutes += 1
      if not tag or route.tag == tag:
         numRoutes += 1
         # Print the route line
         print routeFmt.format(route.key().prefix().to_string(),
                               route.key().preference(), route.tag())

         # And now print all the vias for this route
         seen_vias = False
         for via in self.ipRouteMgr.ip_route_via_iter(route.key()):
            seen_vias = True
            # Only print out the relevant via information
            if via.hop() != eossdk.IpAddr():
               output = "Nexthop " + via.hop().to_string()
            elif via.intf() != eossdk.IntfId():
               if via.intf().is_null0():
                  output = "Drop route"
               else:
                  output = "Interface " + via.intf.to_string
            elif via.nexthop_group():
               output = "Nexthop group " + via.nexthop_group()
            else:
               output = "Unknown via type"

            if via.mpls_label() != eossdk.MplsLabel():
               output = " and push MPLS Label " + via.mpls_label().to_string()
            print "      -", output

         if not seen_vias:
            print "      - no nexthops!"

   del lock

   # Print a nice footer
   print
   print "Saw", numRoutes, "matching routes out of", totalRoutes, "total routes"
   print


def doRouteDel( self, args ):
   import eossdk
   target = args[ '<target>' ]
   gateway = args.get( '<gateway>' )
   print "route del", target, gateway

   def buildRoute( ipAddr ):
      ip_prefix = eossdk.IpPrefix( ipAddr )
      ip_route_key = eossdk.IpRouteKey( ip_prefix )
      return eossdk.IpRoute( ip_route_key )

   def buildVia( routeKey, hop ):
      route_via = eossdk.IpRouteVia( routeKey )
      route_via.hop_is( eossdk.IpAddr( hop ) )
      route_via.intf_is( eossdk.IntfId( 'Ethernet1' ) )
      return route_via

   route = buildRoute( target )
   if gateway:
      routeVia = buildVia( route.key(), gateway )
      self.ipRouteMgr.ip_route_via_del( routeVia )
      return
   self.ipRouteMgr.ip_route_del( route.key() )


def doRouteAdd( self, args ):
   import eossdk
   target = args[ '<target>' ]
   gateway = args[ '<gateway>' ]

   def buildRoute( ipAddr ):
      ip_prefix = eossdk.IpPrefix( ipAddr )
      ip_route_key = eossdk.IpRouteKey( ip_prefix )
      return eossdk.IpRoute( ip_route_key )

   def buildVia( routeKey, hop ):
      route_via = eossdk.IpRouteVia( routeKey )
      route_via.hop_is( eossdk.IpAddr( hop ) )
      route_via.intf_is( eossdk.IntfId( 'Ethernet1' ) )
      return route_via

   route = buildRoute( target )
   self.ipRouteMgr.ip_route_set( route )
   route.tag_is( 1 )
   self.ipRouteMgr.ip_route_set( route )
   self.ipRouteMgr.ip_route_set( route, eossdk.IP_ROUTE_ACTION_NEXTHOP_GROUP )
   routeVia = buildVia( route.key(), gateway )
   self.ipRouteMgr.ip_route_via_set( routeVia )


# ###############################################################################
# ################# Cli_Command_Definitions #####################################
# ###############################################################################

# --------------------------------------------------------------------------------
# daemon <name>; cli; route add
# --------------------------------------------------------------------------------
class DaemonCliRouteAddCmd( CliCommand.CliCommandClass ):
   syntax = 'route add <target> <gateway>'
   data = {
      'route': "work on agent's configured routes",
      'add': 'add a route',
      '<target>': IpAddrMatcher.ipPrefixMatcher,
      '<gateway>': IpAddrMatcher.ipAddrMatcher,
   }
   handler = doRouteAdd

DaemonCliMode.addCommandClass( DaemonCliRouteAddCmd )

# -------------------------------------------------------------------------------
# daemon <name>; cli; route del
# --------------------------------------------------------------------------------


class DaemonCliRouteDelCmd( CliCommand.CliCommandClass ):
   syntax = 'route del <target> [<gateway>]'
   data = {
      'route': "work on agent's configured routes",
      'del': 'delete a route',
      '<target>': IpAddrMatcher.ipPrefixMatcher,
      '<gateway>': IpAddrMatcher.ipAddrMatcher,
   }
   handler = doRouteDel

DaemonCliMode.addCommandClass( DaemonCliRouteDelCmd )

# --------------------------------------------------------------------------------
# daemon <name>; cli; show routes
# --------------------------------------------------------------------------------


class DaemonCliRouteShowCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'route show_'
   data = {
      'route': "work on agent's configured routes",
      'show_': CliMatcher.KeywordMatcher( 'show',
                                          helpdesc="display the agent's routes" ),
   }
   handler = doRouteShow

DaemonCliMode.addShowCommandClass( DaemonCliRouteShowCmd )


def Plugin( entityManager ):
   pass
