# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliParser
from LauncherDaemonCli import DaemonConfigMode
from CliMode import ConfigMode
import Tac

# --------------------------------------------------------------------------------
# daemon <name>; cli
# --------------------------------------------------------------------------------


class DaemonCliCmd( CliCommand.CliCommandClass ):
   syntax = 'cli'
   data = {
      'cli': 'Special debug mode, see "help" command inside the mode',
   }

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( DaemonCliMode, daemonName=mode.daemonName,
                                  genCfg=mode.genericAgentCfg  )
      mode.session_.gotoChildMode( childMode )

DaemonConfigMode.addCommandClass( DaemonCliCmd )

# TODO: cleanup on no deamon (need to enhance DaemonCli to allow cleanup registry)
sdkHandles = {}


class DaemonCliMode( ConfigMode, BasicCli.ConfigModeBase ):
   name = 'Daemon cli configuration'
   modeParseTree = CliParser.ModeParseTree()

   def enterCmd( self ):
      return 'cli'

   def __init__( self, parent, session, daemonName, genCfg=None, cfg=None ):
      self.daemonName = daemonName
      self.genericAgentCfg = genCfg
      self.aclConfig = cfg
      self.modeKey = "daemon-%s-cli" % daemonName
      self.longModeKey = "daemon-%s-cli" % daemonName
      ConfigMode.__init__( self, parent )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

      if daemonName not in sdkHandles:
         # this is for debugs, so be lazy
         import eossdk
         self.sdk = eossdk.Sdk( daemonName,
                                Tac.addressOf( self.entityManager.cEntityManager() ))
         sdkHandles[daemonName] = self.sdk
      else:
         self.sdk = sdkHandles[daemonName]
      self.ipRouteMgr = self.sdk.get_ip_route_mgr()
      self.sdk.initialize_context()


def doDaemonCliHelp( self, args ):

   print r"""
Here you can implement debug cli commands to control/monitor an EosSdk agent.
Note: the real agent must have been "no shut" at some point in time for the
corresponding agent-specific Sysdb paths to have been created (else writting
to them will fail).
Also, ConfigAgent must have loaded the EosSdk mount points, which are not all
mounted by default (the route ones are because of the "show ip user route" cmd).
This is done by running this command from bash and then restarting ConfigAgent:

  for f in /usr/lib/SysdbMountProfiles/EosSdk_*.include; do          \\
    sudo bash -c "                                                   \\
      cat $f | sed 's/\/EosSdk-%sliceId\([, ]*[^,]*,\)/, Tac::Dir,/' \\
      | sed 's/\/%sliceId\([, ]*[^,]*,\)/, Tac::Dir,/'               \\
      > /usr/lib/SysdbMountProfiles/ConfigAgent_$(basename $f)       \\
    ";                                                               \\
  done;                                                              \\
  cat /usr/lib/SysdbMountProfiles/EosSdkAll                          \\
    | sed '1s/EosSdk.*/ConfigAgent/'                                 \\
    | sed 's/EosSdk_/ConfigAgent_EosSdk_/'                           \\
    > /usr/lib/SysdbMountProfiles/ConfigAgentEosSdkAll

  sudo killall -9 ConfigAgent

   """

# --------------------------------------------------------------------------------
#  daemon <name>; cli; help
# --------------------------------------------------------------------------------


class DaemonCliHelpCmd( CliCommand.CliCommandClass ):
   syntax = 'help'
   data = {
      'help': "useful info and tips",
   }
   handler = doDaemonCliHelp

DaemonCliMode.addCommandClass( DaemonCliHelpCmd )
