# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import Tac

def chipSetFromMask( value=0 ):
   chipSet = Tac.Value( 'Ark::ChipSet' )
   bucketSize = 64
   bucketMask = ( 1 << bucketSize ) - 1
   chipSet.valueLo = value & bucketMask
   chipSet.valueHi = ( value >> bucketSize ) & bucketMask
   return chipSet

