#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

newlinesInRepr = False

class Bunch( dict ):
   """
   Bunch superclass to provide attribute style access
   to state. More info at http://pypi.python.org/pypi/bunch
   """

   def __init__(self, **kwargs):
      dict.__init__(self, kwargs)
      self.__dict__.update(kwargs)

   def __contains__(self, key):
      try:
         return hasattr(self, key) or dict.__contains__(self, key)
      except: # pylint: disable=W0702
         return False

   def __getattr__(self, key):
      """ Return the value of attribute 'key' if found
          otherwise lookup the 'key' in the dictionary; if found, return value
          If neither is found then raise AttributeError exception.
      """
      try:
         return object.__getattribute__(self, key)
      except AttributeError:
         try:
            return self[key]
         except KeyError:
            raise AttributeError(key)

   def __setattr__(self, key, value):
      """ Sets an attribute 'key' to 'value' if the attribute exists,
          otherwise sets 'key-value' pair in the dictionary
      """
      try:
         object.__getattribute__(self, key)
      except AttributeError:
         try:
            self[key] = value
         except:
            raise AttributeError(key)
      else:
         object.__setattr__(self, key, value)

   def __repr__( self ):
      keys = list( self.keys() )
      keys.sort()
      className = self.__class__.__name__
      if newlinesInRepr:
         sep = ",\n" + " " * len( className + "(" )
      else:
         sep = ", "
      args = sep.join(['%s=%r' % (key, self[key]) for key in keys])
      return '%s(%s)' % ( className, args )
