#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''
Utilities for working with collections
'''

from __future__ import absolute_import, division, print_function

def difference( a, b ):
   """Reduce two similar dictionaries to a sparse dictionary containing only
   the keys/values that differ between the two."""
   if type( a ) != type( b ) or not isinstance( a, dict ):
      return ( a, b )

   result = {}
   for k in set( list( a.keys() ) + list( b.keys() ) ):
      if a.get( k ) != b.get( k ):
         result[ k ] = difference( a.get( k ), b.get( k ) )
   return result

def shuffled( list_ ):
   """Like sorted(), only shuffled."""
   import random
   result = list( list_ )
   random.shuffle( result )
   return result

