#!/usr/bin/env python
# Copyright (c) 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.


import Tac, sys


def strToInt( s, base=10 ):
   try:
      i = int( s, base )
   except ValueError:
      if s.startswith( "0b") or s.startswith( "0B" ):
         i = int( s[2:], 2 )
      elif s.startswith( "0x") or s.startswith( "0X" ):
         i = int( s[2:], 16 )
      else:
         print "invalid number format: " + s
         sys.exit( 1 )
   return i

def intToAscii( character ):
   if 0x20 <= character <= 0x7e:
      return chr(character)
   else:
      return "."
   
def format( addr, data, width=16 ):
   length = len(data)

   # FIRST ROW
   idx = addr - (addr % width)  # round down addr
   output = "%02x:" % addr
   strbuf = ""
   # leading spaces
   if length <= width:
      spaces = 0
   else:
      spaces = addr % width
   for x in range(spaces):
      output += (" " * 3)
      strbuf += " "
   # data
   rowlength = min(length , width - spaces)
   for x in range(rowlength):
      output += " %02x" % ord(data[x])
      strbuf += intToAscii(ord(data[x]))
   output += "  " + strbuf + "\n"
   idx = idx + width

   # SUBSEQUENT ROWS
   while idx < addr + length:
      remainder = addr + length - idx
      strbuf = ""
      output += "%02x:" % idx
      rowlength = min(width, remainder)
      for x in range(rowlength):
         output += " %02x" % ord(data[x + idx - addr])
         strbuf += intToAscii(ord(data[x + idx - addr]))

      # pad out the rest of the line (only for the last line)
      for x in range(width - rowlength):
         output += (" " * 3)
         
      output += "  " + strbuf + "\n"
      idx = idx + width
   return output

def binary( value, bytes=4 ):
   """
String rep of an integer in binary, similar to 'hex'
   Turns 0xc7 into 1100 0111
The optional bytes parameter indicates how many bytes wide the value is."""
   return "".join( [((value>>n &1) and "1" or "0") + ((n % 4 == 0) and " " or "")
                    for n in xrange(bytes*8-1,-1,-1)] )

oldLock = "0"

def unlock():
   global oldLock
   oldLock = Tac.run(['scd', 'read', '0x1000'], stdout = Tac.CAPTURE).split()[1]
   if oldLock.endswith( "L" ): oldLock = oldLock[:-1]
   Tac.run(['scd', 'write', '0x1000', '0'], stdout = Tac.CAPTURE)
                
def restoreLock():
   Tac.run(['scd', 'write', '0x1000', oldLock], stdout = Tac.CAPTURE)

def doWrite( busId, seepromId, offset, data, unlock=False ):
   dev = Tac.newInstance( "I2c::Device", busId, seepromId )
   dev.waitBetweenTransactions = 5
   i = 0
   while i < len( data ):
      try:
         if ( len( data ) - i ) >= 2:
            value = ( ord( data[ i + 1 ] ) << 8 ) + ord( data[ i ] )
            dev.word[ offset + i ] = value
            i += 2
         else:
            value = ord(data[ i ])
            dev.byte[ offset + i ] = value
            i += 1
      except MemoryError, e:
         if not unlock:
            print >> sys.stderr, "Error when writing seeprom:\n  "
            print >> sys.stderr, "Perhaps you need to unlock the seeprom to" \
                  " allow writing (try the --unlock option?)"
            sys.exit(1)
         else:
            print >> sys.stderr, "error writing bus", busId, "device", seepromId, \
                  "address", offset + i, "data", value
            raise

def doRead( busId, seepromId, offset, length ):
   result = ''
   dev = Tac.newInstance( "I2c::Device", busId, seepromId )
   i = 0
   while i < length:
      if length - i >= 2:
         val = dev.word[ offset + i ]
         result += chr( val & 0xff )
         result += chr( ( val & 0xff00 ) >> 8 )
         i += 2
      else:
         result += chr( dev.byte[ offset + i ] )
         i += 1
   return result
