# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import os

import LauncherUtil
import MosApi
import mosapi.Utils

def _pathToName( exe ):
   return os.path.basename( exe )

def _buildLauncherArgs( exe, args, env ):
   launcherArgv = (
      list( k + '=' + v for k, v in env.iteritems() )
      + [ exe ]
      + list( args )
   )
   return '/usr/bin/env', launcherArgv

def start_daemon( exe, args=None, env=None ):
   if args is None:
      args = []
   if env is None:
      env = {}

   name = _pathToName( exe )
   agentConfigCliDir = MosApi.MOSAPI_INSTANCE.agentConfigCliDir
   if name in agentConfigCliDir:
      return
   exe, args = _buildLauncherArgs( exe, args, env )
   daemonConfig = agentConfigCliDir.newAgent( name )

   daemonConfig.userDaemon = True
   daemonConfig.useEnvvarForSockId = True
   daemonConfig.exe = exe
   for i, x in enumerate( args ):
      daemonConfig.argv[ i ] = x

   for redProto in LauncherUtil.allRedProtoSet:
      daemonConfig.criteria[ redProto ] = LauncherUtil.activeSupervisorRoleName

   daemonConfig.stable = True

def stop_daemon( exe ):
   del MosApi.MOSAPI_INSTANCE.agentConfigCliDir[ _pathToName( exe ) ]

@mosapi.Utils.notImplemented
def signal_daemon( process, signal ):
   pass

@mosapi.Utils.notImplemented
def check_daemon( process ):
   pass
