# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import MosCli

def _generateCmd( func ):
   command = MosCli.Command( func )
   MosCli.COMMANDS_TO_ADD.append( command )
   return command

# this decorator can be used in two ways:
# 1) @mosapi.cli_command
# 2) @mosapi.cli_command( *p, **k )
# option #2 allows you to pass format args into the func doc
def cli_command( *p, **k ):
   if len( p ) == 1 and callable( p[ 0 ] ) and not k:
      # option #1
      return _generateCmd( p[ 0 ] )
   else:
      # option #2
      def formatDocString( func ):
         func.__doc__ = func.__doc__.format( *p, **k )
         return _generateCmd( func )

      return formatDocString
