# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
#
# from asm-generic/ioctl.h 

_IOC_NRBITS = 8
_IOC_TYPEBITS = 8
_IOC_SIZEBITS = 14
_IOC_DIRBITS = 2

_IOC_NRMASK = ((1 << _IOC_NRBITS)-1)
_IOC_TYPEMASK = ((1 << _IOC_TYPEBITS)-1)
_IOC_SIZEMASK = ((1 << _IOC_SIZEBITS)-1)
_IOC_DIRMASK = ((1 << _IOC_DIRBITS)-1)

_IOC_NRSHIFT = 0
_IOC_TYPESHIFT = (_IOC_NRSHIFT+_IOC_NRBITS)
_IOC_SIZESHIFT = (_IOC_TYPESHIFT+_IOC_TYPEBITS)
_IOC_DIRSHIFT = (_IOC_SIZESHIFT+_IOC_SIZEBITS)

_IOC_NONE = 0
_IOC_WRITE = 1
_IOC_READ = 2

def _IOC(_dir, _type, nr, size):
   return (((_dir) << _IOC_DIRSHIFT) | \
   ((_type) << _IOC_TYPESHIFT) | \
   ((nr)   << _IOC_NRSHIFT) | \
   ((size) << _IOC_SIZESHIFT))

def _IO(_type, nr):
   return _IOC(_IOC_NONE, (_type), (nr), 0)
def _IOR(_type, nr, size):
   return _IOC(_IOC_READ, (_type), (nr), (size))
def _IOW(_type, nr, size):
   return _IOC(_IOC_WRITE, (_type), (nr), (size))
def _IOWR(_type, nr, size):
   return _IOC(_IOC_READ|_IOC_WRITE, (_type), (nr), (size))
def _IOR_BAD(_type, nr, size):
   return _IOC(_IOC_READ, (_type), (nr), size)
def _IOW_BAD(_type, nr, size):
   return _IOC(_IOC_WRITE, (_type), (nr), size)
def _IOWR_BAD(_type, nr, size):
   return _IOC(_IOC_READ|_IOC_WRITE, (_type), (nr), size)

def _IOC_DIR(nr):
   return (((nr) >> _IOC_DIRSHIFT) & _IOC_DIRMASK)
def _IOC_TYPE(nr):
   return (((nr) >> _IOC_TYPESHIFT) & _IOC_TYPEMASK)
def _IOC_NR(nr):
   return (((nr) >> _IOC_NRSHIFT) & _IOC_NRMASK)
def _IOC_SIZE(nr):
   return (((nr) >> _IOC_SIZESHIFT) & _IOC_SIZEMASK)

