#!/usr/bin/env python
# Copyright (c) 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

ETH_P_ARISTA_NONE         = 0x0029
ETH_P_ARISTA              = 0x002a     # improve PF_PACKET filtering efficiency
ETH_P_ARISTA_ARP_VLAN     = 0x002b     # focalpoint arp cache miss
ETH_P_ARISTA_RPF_FAILURE  = 0x002c     # multicast rpf failure pkt
ETH_P_ARISTA_SFLOW        = 0x002d     # Sflow packets
ETH_P_ARISTA_ACL          = 0x002e     # packets logged by an ACL
ETH_P_ARISTA_PTP          = 0x002f     # PTP packets with timestamp header
ETH_P_ARISTA_MIRROR       = 0x0030     # mirror packets
ETH_P_ARISTA_OPENFLOW     = 0x0031     # packets w/OpenFlow recv header
ETH_P_ARISTA_ARP_INSPECT  = 0x0036     # ARP packets for inspection
ETH_P_ARISTA_LANZ         = 0x0035     # LANZ packets
ETH_P_ARISTA_EGRESS_ACL   = 0x0037     # packets logged by Egress ACL
ETH_P_ARISTA_CFM          = 0x0038     # CFM frames
ETH_P_ARISTA_PACKET_CAPTURE = 0x0039   # Packet capture frames
ETH_P_ARISTA_MPLS         = 0x0042     # Trapped MPLS pkts
ETH_P_ARISTA_VCN          = 0x1001     # VCN frames
ETH_P_ARISTA_DOT1X_MBA    = 0x1002     # Dot1x frames from a MBA-enabled port
ETH_P_ARISTA_AEGIS        = 0x102e     # packets logged by Aegis traffic policy
ETH_P_ARISTA_VXLAN_ENCAP  = 0x1033     # Vxlan packets needing s/w fwrding
ETH_P_ARISTA_VTEP_LEARN   = 0x1034     # Vxlan VTEP learning packets
ETH_P_ARISTA_VXLAN_ARP    = 0x1040     # Vxlan encapsulated arp packets
ETH_P_ARISTA_VXLAN_ENCAP_HI = 0x1041   # Vxlan pkts needing hipri s/w fwrding
ETH_P_ARISTA_VXLAN_DHCP   = 0x1045     # Vxlan encapsulated dhcp packets
ETH_P_ARISTA_IPV6_RPF_FAILURE = 0x1046 # IPv6 multicast rpf failure pkt
ETH_P_ARISTA_SFLOW_ETBA   = 0x8130
ETH_P_ARISTA_OPENFLOW_ETBA = 0x8131
ETH_P_ARISTA_ARP_INSPECT_ETBA = 0x8133
ETH_P_ARISTA_ARP_SNOOP = 0x8135
ETH_P_ARISTA_SAI = 0x8136
ETH_P_ARISTA_OPENFLOW_UNSUPP = 0x8137
ETH_P_ARISTA_MIRROR_CPU = 0x82DD

ARP_VLAN_DATA_SNAPLEN     = 128

TC_PRIO_INTERACTIVE       = 6
TC_PRIO_CONTROL           = 7

VXLAN_TAGGED_FLAG         = 0x4000  # vxlan inner pkt vxlan vlan tag inserted
VXLAN_TAGGED_TRUNK_FLAG   = 0x2000  # vxlan inner pkt vxlan vlan tag inserted 
                                    # but only in trunk mode
VXLAN_DOT1QTUNNEL_FLAG    = 0x1000  # vxlan ingress dot1tunnel 
VXLAN_CPUPORT_FLAG        = 0x0800  # vxlan ingress cpu port
VXLAN_MLAG_SRCPORT_FLAG   = 0x0400  # vxlan ingress is MLAG port
VXLAN_SRC_VTEP_EXT_FLAG   = 0x0200  # Vxlan frame has vxlan_src_vtep_ext appended

#Sflow Trailer Flags
SFLOW_TRAILER_OUTPUT_INTERFACE_PRESENT  = 0x1
SFLOW_TRAILER_FAP_ID_PRESENT            = (0x1 << 1)
SFLOW_TRAILER_TUNNEL_INDEX_PRESENT      = (0x1 << 2)
SFLOW_TRAILER_INPUT_INTERFACE_PRESENT   = (0x1 << 3)
SFLOW_TRAILER_EGRESS_PKT                = (0x1 << 4)
SFLOW_TRAILER_EGRESS_MODIFIED_PKT       = (0x1 << 5)
SFLOW_TRAILER_ORIGINAL_PKT_SIZE_PRESENT = (0x1 << 6)

#Sflow Interface.
SFLOW_FORMAT_SHIFT = 30
SFLOW_FORMAT_SINGLE_INTF = 0x0
SFLOW_FORMAT_PKT_DISCARD = (0x1 << SFLOW_FORMAT_SHIFT)
SFLOW_FORMAT_MULTIPLE_INTFS = (0x2 << SFLOW_FORMAT_SHIFT)
SFLOW_IFINDEX_MASK = 0x3FFFFFFF
SFLOW_INTERNAL_INTERFACE = 0x3FFFFFFF
SFLOW_OUTPUT_UNKNOWN = 0x0
SFLOW_INPUT_UNKNOWN = 0x0
SFLOW_DISCARD_REASON_UNKNOWN = 256
SFLOW_DISCARD_REASON_ACL = 258
SFLOW_TRAILER_LEN = 27 # should be equal to sizeof(struct sflow_arista_trailer)

OPENFLOW_COPY_REASON_ACTION      = 0     # OpenFlow copy due to action
OPENFLOW_COPY_REASON_NO_MATCH    = 1     # OpenFlow copy due to no match 
OPENFLOW_COPY_REASON_INVALID_TTL = 2     # OpenFlow copy due to invalid ttl
OPENFLOW_HDR_LEN                 = 8     # Openflow header len

