#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ctypes
class FabDevStats(ctypes.Structure):
   _fields_ = [
      ('reserved', ctypes.c_uint32),
      ('up', ctypes.c_uint32),
      ('tx', ctypes.c_uint64),
      ('rx', ctypes.c_uint64),
      ('rxcmicdma', ctypes.c_uint64),
      ('rxcmic', ctypes.c_uint64),
      ('txactive', ctypes.c_uint64),
      ('txpoll', ctypes.c_uint64),
      ('txreclaim', ctypes.c_uint64),
      ('txbytes', ctypes.c_uint64),
      ('rxbytes', ctypes.c_uint64),
      ('rxarpinspect', ctypes.c_uint64),
      ('rxerroredpkts', ctypes.c_uint64),
   ]
   def __print__(self):
      i = 0
      for field in self._fields_:
         print field[0] + ' : ' + str(getattr(self, self._fields_[i][0]))
         i = i + 1
