# Copyright (c) 2010-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import

import Agent
from Arnet.NsLib import DEFAULT_NS
import BothTrace
import Cell
import SharedMem
import Smash
import Tac
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "ZeroTouch" )
bt0 = BothTrace.trace0

class ZeroTouch( Agent.Agent ):
   def __init__( self, entityManager, agentName='ZeroTouch', blocking=False ):
      bt0( "Starting ZeroTouch Agent" )
      self.blocking_ = blocking
      self.em_ = entityManager
      self.ztpConfig_ = None
      self.ztpStatus_ = None
      self.ztpDhcpStatus_ = None
      self.ethPhyIntfConfigDir_ = None
      self.ethPhyIntfStatusDir_ = None
      self.speedGroupConfigSliceDir_ = None
      self.speedGroupStatusSliceDir_ = None
      self.vlanIntfConfigDir_ = None
      self.vlanIntfStatusDir_ = None
      self.allIntfStatusDir_ = None
      self.allIntfStatusLocalDir_ = None
      self.ethIntfStatusDir_ = None
      self.entityMib_ = None
      self.ipConfig_ = None
      self.l3ConfigDir_ = None
      self.ipStatus_ = None
      self.ip6Config_ = None
      self.ip6Status_ = None
      self.routingConfig_ = None
      self.netConfig_ = None
      self.netStatus_ = None
      self.hwTpmConfig_ = None
      self.hwTpmStatus_ = None
      self.reloadConfig_ = None
      self.fileReplicationStatus_ = None
      self.sysLoggingConfig_ = None
      self.xgc_ = None
      self.raPacketStatus_ = None
      self.kniStatus_ = None
      self.zerotouch_ = None

      Agent.Agent.__init__( self, entityManager )

   def doInit( self, entityManager ):
      mg = entityManager.mountGroup()

      self.ztpConfig_ = mg.mount( 'zerotouch/config', 'ZeroTouch::Config', 'w' )
      self.ztpStatus_ = mg.mount( 'zerotouch/status', 'ZeroTouch::Status', 'w' )
      self.ztpDhcpStatus_ = mg.mount( 'zerotouch/dhcp/status',
                                      'ZeroTouch::DhcpStatus', 'r' )
      self.ethPhyIntfConfigDir_ = self.createLocalEntity(
         'AllEthPhyIntfConfigDir',
         'Interface::AllEthPhyIntfConfigDir',
         'interface/config/eth/phy/all' )
      self.ethPhyIntfStatusDir_ = self.createLocalEntity(
         'AllEthPhyIntfStatusDir',
         'Interface::AllEthPhyIntfStatusDir',
         'interface/status/eth/phy/all' )
      self.speedGroupConfigSliceDir_ = mg.mount(
         'interface/archer/config/eth/phy/speedgroup/slice',
         'Tac::Dir', 'wi' )
      self.speedGroupStatusSliceDir_ = mg.mount(
         'interface/archer/status/eth/phy/speedgroup/slice',
         'Tac::Dir', 'ri' )
      self.vlanIntfConfigDir_ = mg.mount( 'interface/config/eth/vlan',
                                          'Interface::VlanIntfConfigDir', 'w' )
      self.vlanIntfStatusDir_ = mg.mount( 'interface/status/eth/vlan',
                                          'Interface::VlanIntfStatusDir', 'r' )
      self.allIntfStatusDir_ = self.createLocalEntity(
         'AllIntfStatusDir',
         'Interface::AllIntfStatusDir',
         'interface/status/all' )
      self.allIntfStatusLocalDir_ = self.createLocalEntity(
         'AllIntfStatusLocalDir',
         'Interface::AllIntfStatusLocalDir',
         Cell.path( 'interface/status/local' ) )
      self.ethIntfStatusDir_ = self.createLocalEntity (
         'EthIntfStatusDir',
         'Interface::EthIntfStatusDir',
         'interface/status/eth/intf' )
      self.entityMib_ = mg.mount( 'hardware/entmib', 'EntityMib::Status', 'r' )
      self.ipConfig_ = mg.mount( 'ip/config', 'Ip::Config', 'w' )
      self.l3ConfigDir_ = mg.mount( 'l3/intf/config', 'L3::Intf::ConfigDir', 'w' )
      Tac.Type( 'Ira::IraIpStatusMounter' ).doMountEntities( mg.cMg_, True, False )
      self.ipStatus_ = mg.mount( 'ip/status', 'Ip::Status', 'r' )
      self.ip6Config_ = mg.mount( 'ip6/config', 'Ip6::Config', 'w' )
      self.ip6Status_ = mg.mount( 'ip6/status', 'Ip6::Status', 'r' )
      self.routingConfig_ = mg.mount( 'routing/routelistconfig',
            'Routing::RouteListConfig', 'w' )
      self.netConfig_ = mg.mount( 'sys/net/config', 'System::NetConfig', 'w' )
      self.netStatus_ = mg.mount( Cell.path( 'sys/net/status' ),
                                  'System::NetStatus', 'r' )
      self.hwTpmConfig_ =  mg.mount( Cell.path('hardware/tpm/config'),
                                     'Hardware::Tpm::Config','r' )
      self.hwTpmStatus_ =  mg.mount( Cell.path('hardware/tpm/status'),
                                     'Hardware::Tpm::Status','r' )
      self.reloadConfig_ = mg.mount( Cell.path( 'sys/reload/config' ),
                                     'System::Reload::Config', 'w' )
      self.fileReplicationStatus_ = mg.mount( 'redundancy/fileReplication/status',
                                              'FileReplication::Status', 'r' )
      self.sysLoggingConfig_ = mg.mount( 'sys/logging/config', 'LogMgr::LogConfig',
                                         'w' )
      self.xgc_ = mg.mount( 'hardware/xcvr/xgc', 'Xcvr::Xgc', 'w' )
      self.raPacketStatus_ = mg.mount( 'routing6/routerAdvt/raPacketStatus',
                                       'RouterAdvt::RaPacketStatus',
                                       'r' )

      shmemEm = SharedMem.entityManager( sysdbEm=entityManager )
      self.kniStatus_ = shmemEm.doMount( 'kni/ns/%s/status' % DEFAULT_NS,
                                         'KernelNetInfo::Status',
                                         Smash.mountInfo( 'keyshadow' ) )
      self.localEntitiesCreatedIs( True )

      def _finish():
         local = self.em_.root().parent
         self.zerotouch_ = local.newEntity( 'ZeroTouch::Root', 'zerotouch' )
         self.zerotouch_.agent = ( self.ztpConfig_,
                                   self.ztpStatus_,
                                   self.ztpDhcpStatus_,
                                   self.ethPhyIntfConfigDir_,
                                   self.ethPhyIntfStatusDir_,
                                   self.speedGroupConfigSliceDir_,
                                   self.speedGroupStatusSliceDir_,
                                   self.vlanIntfConfigDir_,
                                   self.vlanIntfStatusDir_,
                                   self.allIntfStatusDir_,
                                   self.allIntfStatusLocalDir_,
                                   self.kniStatus_,
                                   self.ethIntfStatusDir_,
                                   self.entityMib_,
                                   self.ipConfig_,
                                   self.l3ConfigDir_,
                                   self.ipStatus_,
                                   self.ip6Config_,
                                   self.ip6Status_,
                                   self.routingConfig_,
                                   self.netConfig_,
                                   self.netStatus_,
                                   self.reloadConfig_,
                                   self.fileReplicationStatus_,
                                   self.sysLoggingConfig_,
                                   self.xgc_,
                                   self.hwTpmConfig_,
                                   self.hwTpmStatus_,
                                   self.raPacketStatus_ )

      mg.close( _finish, blocking=self.blocking_ )

