#!/usr/bin/env python
# Copyright (c) 2008, 2009 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""
This file contains various constants used for xcvr management.
"""

# --------------------------------------------------------------------------
#
# Table mapping specific xcvr model number to its attenuation value.
# This is a hack that I'd rather not have to implement, but we're
# stuck with certain cables that do not yet have SFF-8089 data in
# their ID EEPROMs.
#
# Keys in this table are the "Vendor name" + "-" + "Vendor PN", as
# programmed into the ID EEPROM as per SFF-8472.
#
# The values in this table are the complete end-to-end attenutation of
# the cable, in units of Decibels.
#
# --------------------------------------------------------------------------

modelToAttn = {
   "Arastra, Inc.   -CAB-SFP-SFP-1M  " : 4.3,
   "Arastra, Inc.   -CAB-SFP-SFP-2M  " : 7.3,
   "Arastra, Inc.   -CAB-SFP-SFP-3M  " : 10.7,
   "Arastra, Inc.   -CAB-SFP-SFP-5M  " : 10.3,
   "Arastra, Inc.   -CAB-SFP-SFP-7M  " : 13.7,
   "Arastra, Inc.   -CAB-SFP-SFP-10M " : 19.0,
   "Molex Inc.      -74765-0902      " : 5.0,   # 5.0dB loopback
   "Molex Inc.      -74752-4301      " : 10.7,  # 3m 30AWG
   "Molex Inc.      -74752-4501      " : 10.3,  # 5m 24AWG
   "Molex Inc.      -74752-4701      " : 13.7,  # 7m 24AWG
}


def Plugin( context ):
   # "context" is a Xcvr::ModelToAttenuation
   for (model,attn) in modelToAttn.items():
      context.attenuation[ model ] = attn
