#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Tac

VxlanTunnelType = Tac.Type( "Vxlan::VxlanTunnelType" )

def tunnelTypeToString( tunnelType ):
   tunnelTypeToStr = { VxlanTunnelType.vxlanTunnel : 'unicast',
                       VxlanTunnelType.vxlanHwHerTunnel : 'flood',
                       VxlanTunnelType.vxlanL2EcmpMemberTunnel : 'ecmp',
                       VxlanTunnelType.vxlanMcastTunnel : 'multicast' }
   return tunnelTypeToStr.get( tunnelType, '' )
