#!/usr/bin/env python
# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Agent, Tracing
import os
import Cell
import SharedMem
import Smash
from Arnet.NsLib import DEFAULT_NS

__defaultTraceHandle__ = Tracing.Handle( "Vm" )
t0 = Tracing.trace0

class Vm( Agent.Agent ):
   def __init__( self, entityManager, agentName="Vm", blocking=False ):
      t0( "Starting Vm Agent" )
      self.blocking = blocking
      Agent.Agent.__init__( self, entityManager, agentName=agentName )

   def doInit( self, entityManager ):
      t0( "Init Vm Agent" )
      mountGroup = entityManager.mountGroup()
      local = entityManager.root().parent
      shmemEm = SharedMem.entityManager( sysdbEm=entityManager )

      self.config = mountGroup.mount( "vm/config", 
                         "Vm::Config", 'r' )
      self.status = mountGroup.mount( "vm/status", 
                         "Vm::Status", 'w' )
      self.bivm = mountGroup.mount("bridging/input/config/vm", 
                      "Bridging::Input::Config", 'w' )

      self.createLocalEntity( "AllIntfStatusDir",
                              "Interface::AllIntfStatusDir",
                              "interface/status/all" )
      self.createLocalEntity( "AllIntfStatusLocalDir",
                              "Interface::AllIntfStatusLocalDir",
                              Cell.path( "interface/status/local" ) )
      self.localEntitiesCreatedIs( True )

      self.aisd = entityManager.getLocalEntity( 'interface/status/all' )
      self.aisld = entityManager.getLocalEntity(
              Cell.path( 'interface/status/local' ) )
      self.kisd = local.newEntity( "Interface::DeviceIntfStatusDir",
                                   "vmKernelIntfStatus" )
      self.kniStatus = shmemEm.doMount( "kni/ns/%s/status" % DEFAULT_NS,
                                        "KernelNetInfo::Status",
                                        Smash.mountInfo( 'keyshadow' ) )

      def _finish():
         # Set fdbConfig priority. This determines which ethAddr
         # wins, when there are multiple configs with the same ethAddr
         self.bivm.fdbConfigPriority = 10
         self.root_ = local.newEntity( 'Vm::Root', 'root' )
         self.root_.agent = ( self.config, self.status, 
                              self.aisd, self.aisld, self.kisd,
                              self.kniStatus, self.bivm );

      if( self.blocking ):
         mountGroup.close( blocking=True )
         _finish()
      else:
         mountGroup.close( _finish )

def main():
   # Disable annoying msr (debug) errors from kvm
   ignoreMsrFile = '/sys/module/kvm/parameters/ignore_msrs'
   if os.path.exists( ignoreMsrFile ):
      cmd = "\"echo 1 > %s\"" % ignoreMsrFile
      os.system( "echo %s | sudo sh" % cmd)

   container = Agent.AgentContainer( [ Vm ], passiveMount=True, \
                                     agentTitle='Vm' )
   container.runAgents()

