#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import subprocess

import VerifyPrefdlLib

def main():
   prefdl = subprocess.check_output( [ 'genprefdl' ] )
   try:
      VerifyPrefdlLib.verifyPrefdl( prefdl )
   except VerifyPrefdlLib.VerificationError as excep:
      print( "Prefdl Verification Failure" )
      print( excep )
      exit( 1 )
   print( "Prefdl Verified OK" )
   exit( 0 )

if __name__ == "__main__":
   main()
