# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from TypeFuture import TacLazyType
import Toggles.TunnelToggleLib

EncapIdType = TacLazyType( "Tunnel::TunnelTable::EncapId" )
EncapType = TacLazyType( "Tunnel::TunnelTable::EncapType" )
TacTunnelType = TacLazyType( "Tunnel::TunnelTable::TunnelType" )
TunnelIdType = TacLazyType( "Tunnel::TunnelTable::TunnelId" )

tunnelTypeStrDict = {
   'bgpLuTunnel': 'BGP LU',
   'ldpTunnel': 'LDP',
   'staticV4Tunnel': 'Static',
   'staticV6Tunnel': 'Static IPv6',
   'bgpLuPushTunnel': 'BGP LU Push',
   'srV6Tunnel': 'IS-IS SR IPv6',
   'srV4Tunnel': 'IS-IS SR IPv4',
   'srTeSegmentListTunnel': 'SR-TE',
   'srTePolicyTunnel': 'SR-TE Policy',
   'rsvpTunnel': 'RSVP',
   'rsvpLerTunnel': 'RSVP LER',
   'rsvpFrrTunnel': 'RSVP FRR',
   'nexthopGroupTunnel': 'Nexthop Group',
   'tiLfaTunnel': 'TI-LFA',
   'invalidTunnel': 'invalidTunnel',
   'nexthopTunnel': 'Nexthop',
   'staticTunnel': 'Static MPLS',
   'evpnVxlanTunnel': 'EVPN VXLAN',
   'srTunnel': 'IS-IS SR',
   'staticInterfaceTunnel': 'Static Interface',
   'vxlanVtepEncapTunnel': 'VXLAN VTEP Encap',
   'maxTunnelType': 'maxTunnelType'
}

if Toggles.TunnelToggleLib.toggleOspfSegmentRoutingTunnelEnabled():
   tunnelTypeStrDict[ 'ospfSrTunnel' ] = 'OSPF SR'

tunnelTypesReverseStrDict = { v: k for k, v in tunnelTypeStrDict.iteritems() }

# Get the enum values for EncapType.
tunnelTypeEnumValues = tuple( [
   TunnelIdType.tunnelTypeToCliStrep( tunnelType, True )
   for tunnelType in TacTunnelType.attributes
] )

encapTypeEnumValues = tuple( [
   EncapIdType.typeCliStrep( encapType, True ) for encapType in EncapType.attributes
] )
