#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import random
import Tac

routingHwStatus = Tac.newInstance( "Routing::Hardware::Status", "name" )
minTunnelIntfNum = 0
maxTunnelIntfNum = routingHwStatus.maxTunnelIntfNum - 1
tunnelDefaultMasklen = 24
tunnelDefaultTtl = 0
tunnelDefaultTos = 0
tunnelDefaultMtu = 0
tunnelDefaultKey = 0
tunnelDefaultMaxMss = 0

def randomMiddleTunnelIndex():
   return random.randrange( minTunnelIntfNum + 1, maxTunnelIntfNum - 1 )

def randomLimitTunnelIndex():
   return random.choice( [ minTunnelIntfNum, maxTunnelIntfNum ] )

def randomAnyTunnelIndex():
   return random.choice( [ minTunnelIntfNum, maxTunnelIntfNum,
                           randomMiddleTunnelIndex() ] )

def randomTunnelIndex():
   return randomLimitTunnelIndex()
