#!/usr/bin/env python
# Copyright (c) 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This file is a place for misc shared constructs.

from AaaPluginLib import TR_ERROR, TR_WARN, TR_INFO
from BothTrace import traceX as bt
from BothTrace import Var as bv
import Tac

import threading

class CounterCallback( object ):
   mutex = threading.Lock()

   # IMPORTANT: keep this consistent with taclib.h
   tacacsCounterAttrs_ = ( "connOpens",
                           "connCloses",
                           "messagesSent",
                           "messagesReceived",
                           "connDisconnects",
                           "connFails",
                           "connTimeouts",
                           "receiveErrors",
                           "receiveTimeouts",
                           "sendTimeouts",
                           "dnsErrors" )

   @staticmethod
   def attrNameFromIndex( idx ):
      # These match up with the libtacplus constants starting with TAC_STAT_.
      return CounterCallback.tacacsCounterAttrs_[ idx ]

   def __init__( self, status, hostspec ):
      self.status = status
      self.hostspec = hostspec

   def __call__( self, counterType, delta ):
      attrName = CounterCallback.attrNameFromIndex( counterType )
      traceLevel = TR_ERROR if counterType >= 4 else TR_INFO
      bt( traceLevel, "TACACS+ counter", bv( attrName ), "host",
          bv( self.hostspec.stringValue() ) )
      with self.mutex:
         if not self.status.counter.has_key( self.hostspec ):
            bt( TR_WARN, "TACACS+ counters missing entry for",
                bv( self.hostspec.stringValue() ) )
            return # Operator probably removed tacacs host in the
                   # middle of the authentication request.
         c = Tac.nonConst( self.status.counter[ self.hostspec ] )
         old = c.__getattribute__( attrName )
         new = old + delta
         c.__setattr__( attrName, new )
         self.status.counter[ self.hostspec ] = c
