# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Cell, Tracing
import LauncherLib, LauncherUtil
import AgentsRunnabilityEvaluator as AgentsRE

# pkgdeps: rpm Asu-lib

__defaultTraceHandle__ = Tracing.Handle( 'LauncherSysdb' )

t0 = Tracing.trace0
t3 = Tracing.trace3
t8 = Tracing.trace8

activeSupervisorRoleName = LauncherUtil.activeSupervisorRoleName
allSupervisorsRoleName = LauncherUtil.allSupervisorsRoleName
allCellsRoleName = LauncherUtil.allCellsRoleName

RedundancyMode = Tac.Type( 'Redundancy::RedundancyMode' )

# We stuff all global variables for this module into a class and shove it into
# entityManager. This lets us create two entityManager in same address space without
# stomping on each other, for example, in test MlagNoEntityLog.py.
class LauncherSysdbState( object ):
   def __init__( self, entMan ):
      self.redModReactor = None
      self.stageDirReactor = None
      self.bootComplete = False
      self.agentConfigDir = None
      self.agentShutdownConfigDir = None
      self.agentValgrindConfigDir = None
      self.agentStatusDir = None
      self.launchCandidateDir = None
      self.agentsREInstance_ = None
      # Stash the reference to agentConfigIs. Useful for tests to play with custom
      # agent config w/o having to create SysdbPlugin files.
      # I would have loved to keep a consistent api ( eg, entMan.agentConfigIs ) for
      # both test as well as code, but I don't see a way since we don't have a hook
      # which we can be call before SysdbPlugins load time( when the api is needed ).
      self.agentConfigIs = deprecatedAgentConfigIs
      self.cfgToRoles = []

sysConfigSysdbPath = 'sys/config'

def createLauncherSysdbState( entMan ):
   '''initialize required mount points, and other objects/reactors.
      Note that this function may be called safely multiple times.'''

   if hasattr( entMan, 'launcherSysdbState' ):
      t8( 'createLauncherSysdbState', 'already initialized. return early.' )
      return
   t8( 'createLauncherSysdbState', 'initializing' )

   launcherState = LauncherSysdbState( entMan )
   entMan.launcherSysdbState = launcherState

   # Create a dir in which the AgentConfigDir live.
   launcherState.agentConfigDir = entMan.lookup( LauncherLib.agentConfigDirPath )

   # Create a dir in which the AgentStatusDir live.
   launcherState.agentStatusDir = entMan.lookup( LauncherLib.agentStatusDirPath )

   launcherState.agentValgrindConfigDir = entMan.lookup(
      'sys/config/agentValgrindConfigDir' )

   launcherState.agentShutdownConfigDir = entMan.lookup(
                           LauncherLib.agentShutdownConfigDirPath )

   launchCandidateDir = entMan.lookup( LauncherLib.launchCandidateDirPath )

   # start off with clean sys/config/launchCandidate
   if not LauncherLib.isSsoStandby( entMan.redundancyStatus() ):
      launchCandidateDir.agent.clear()
   launcherState.launchCandidateDir = launchCandidateDir

def agentConfigIs( entMan, roleStrOrDict, agentCfgDict ):
   assert False, "This method has been deprecated. Launcher.agentConfigIs() " + \
      "functionality has been moved out from Sysdb plugins into Launcher " + \
      "plugins, please look for an example in /src/Aaa/LauncherPlugin"

# *********************************** DEPRECATED ***********************************
# Do not call this from SysdbPlugins, instead use agentConfigIs() in LauncherPlugins
# *********************************** DEPRECATED ***********************************
def deprecatedAgentConfigIs( entMan, roleStrOrDict, agentCfgDict ):
   t8( 'agentConfigIs', agentCfgDict[ "name" ], roleStrOrDict )
   # The SysdbPlugin is called only once on each supe.
   createLauncherSysdbState( entMan )
   agentName = agentCfgDict[ "name" ]
   redStatus = entMan.redundancyStatus()
   launcherState = entMan.launcherSysdbState
   agentCfgs = launcherState.agentConfigDir.agent
   agentSts = launcherState.agentStatusDir.agent

   if LauncherLib.isSsoStandby( redStatus ):
      # By this time, we should have agentStatus and agentConfigs populated
      agentStatusEntity = agentSts.get( agentName )
      assert agentStatusEntity, \
            "agent %s not found in agent status dir" % agentName
      agentConfigEntity = agentStatusEntity.agentConfig
      assert agentConfigEntity, \
            "agent %s not found in agent config dir" % agentName
      return
   LauncherUtil.launcherAgentConfigIs( entMan, agentCfgs, agentSts, roleStrOrDict,
                                       agentCfgDict,
                                       launcherState.launchCandidateDir,
                                       launcherState.agentValgrindConfigDir,
                                       userDaemon=False,
                                       updateRoleCfg=launcherState.bootComplete )

def createAgentsRunnabilityInstance( entMan ):
   stageCompletionstatus_ = {}
   stageProgress_ = {}
   stageInputDir_ = {}
   stageAgentStatus_ = {}

   sysdbRoot = entMan.root()
   fatalError = sysdbRoot.entity[ \
         Cell.path( 'fatalError/config/request/sysdbLauncher' ) ]

   assert fatalError != None
   for stageClass in AgentsRE.stageClassEnum:
      t0( "Creating reactors for stage class %s" % stageClass.name )
      stageProgress_[ stageClass.name ] =  sysdbRoot.entity[ \
                               Cell.path( "stage/%s/progress" % stageClass.name ) ]
      stageCompletionstatus_[ stageClass.name ] =  sysdbRoot.entity[ \
                       Cell.path( "stage/%s/completionstatus" % stageClass.name ) ]
      stageInputDir_[ stageClass.name ] = sysdbRoot.entity[ \
                                   Cell.path( "stageInput/%s" % stageClass.name ) ]
      stageAgentStatus_[ stageClass.name ] = sysdbRoot.entity[ \
                    Cell.path( "stageAgentStatus/%s/Launcher" % stageClass.name ) ]
      assert stageProgress_[ stageClass.name ] != None
      assert stageCompletionstatus_[ stageClass.name ] != None
      assert stageInputDir_[ stageClass.name ] != None
      assert stageAgentStatus_[ stageClass.name ] != None

   return AgentsRE.AgentsRunnabilityEvaluator(
      stageCompletionstatus_, stageProgress_, stageInputDir_, stageAgentStatus_,
      fatalError, entMan, entMan.redundancyStatus() )

