#!/usr/bin/env python
# Copyright (c) 2008, 2009 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import sys, os, glob
import argparse
import Swi

def rpmInSwiFunc( *args ):
   def rpmWithinExtractedSwi( rootdir ):
      root = glob.glob( os.path.join( rootdir, "rootfs-*.dir" ))[0]
      Swi.run( [ "sudo", "rpm", "--root=%s" % root ] + list( args ) )
   return rpmWithinExtractedSwi

def rpm( swifile, opts, *args ):
   rpmWithinExtractedSwi = rpmInSwiFunc( *args )
   Swi.inSwi( swifile, [ rpmWithinExtractedSwi ], fast=opts.fast,
              outputfile=opts.file, readOnly=opts.readOnly )

def addRpmOptions( op ):
   op.add_argument( '--fast',
                    help='skip compression (will generate bigger SWI image)',
                    action='store_true' )
   op.add_argument( '-o', '--output',
                    dest='file',
                    help='output the swi into <file>',
                    action='store' )
   op.add_argument( '-r', '--readOnly',
                    help='skip swi generation after rpm execution',
                    action='store_true' )

def rpmHandler( args=sys.argv[1:] ):
   # not using optparse because we want people to run swi rpm EOS.swi -U foo.rpm
   # and optparse wants to parse -U
   op = argparse.ArgumentParser(
         prog="swi rpm",
         description="Updating/removing RPMs in a SWI file",
         usage="usage: %(prog)s [--fast] [-o <file>] EOS.swi [options]" )
   addRpmOptions( op )

   opts, args = op.parse_known_args( args )
   if len( args ) < 2:
      op.error( 'Missing arguments' )

   rpm( args[ 0 ], opts, *args[ 1: ] )

