# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import collections
import csv
import glob
import os
import sys

import Swi

def licenses( rootdir ):
   root = glob.glob( os.path.join( rootdir, "rootfs-*.dir" ))[0]
   cmd = [ 'rpm', '--root=' + root, '-qa', '--qf=%{SOURCERPM} %{LICENSE}\n' ]
   pkgList = Swi.runAndReturnOutput( cmd, printStdout=False )
   pkgLicense = collections.defaultdict( dict )
   for line in pkgList.split( "\n" ):
      if line:
         ( pkg, l ) = line.split( ' ', 1 )
         pkgLicense[ pkg ][ l ] = True
   writer = csv.writer( sys.stdout )
   # Header
   writer.writerow( ( 'Software', 'License',
                      "Went through Arista's open source approval process?" ) )
   for pkg in sorted( pkgLicense.keys() ):
      for l in sorted( pkgLicense[ pkg ].keys() ):
         if 'Arista' in l:
            continue
         if 'Proprietary' in l:
            continue
         writer.writerow( ( pkg, l, 'YES' ) )

def licensesHandler( args ):
   if len( args ) != 1:
      print( "Need SWI file" )

   Swi.inSwi( args[ 0 ], [ licenses ], readOnly=True )

