#!/usr/bin/env python
# Copyright (c) 2008, 2009 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import zipfile
import optparse
import sys
import os
import tarfile
import Swi
import SwiSignLib
import Tac

def swivers( file ):

   # For cEOS case. Unfortunately tarfile library does not have the --occurrence
   # option which allows tar to extract only the first occurrence of a file and
   # returning immediately. This is 100X faster when dealing with a 3.5 GB tar.
   if tarfile.is_tarfile( file ) or file.endswith( '.tar.xz' ):
      swiVersionPath = "etc/swi-version"
      os.system( "tar -C /tmp --extract --file=%s --occurrence ./%s" %
                 ( file, swiVersionPath ) )
      tmpSwiVersionPath = os.path.join( "/tmp", swiVersionPath )
      with open( tmpSwiVersionPath ) as f:
         print f.read()
      os.remove( tmpSwiVersionPath )
      return
   try:
      # ZipFile() doesn't check whether it's a zipfile or not, and can
      # behave badly if something is not a zipfile.
      if not zipfile.is_zipfile( file ):
         raise zipfile.BadZipfile( "no magic" )
      z = zipfile.ZipFile( file )
      if 'version' not in z.namelist():
         print "%s does not appear to be a swi image (no version)." % file
         return
      versionFiles = ['version'] \
                     + [i for i in z.namelist() if i.startswith('version.')]
      for i in versionFiles:
         version = z.read( i )
         print "%s:" % i
         print version
   except zipfile.BadZipfile:
      print "%s does not appear to be a swi image." % file

def infoHandler( args=sys.argv[1:] ):
   op = optparse.OptionParser(
         prog="swi info",
         usage="usage: %prog EOS.swi" )
   op.add_option( "--verify-signature", action="store_true", 
         dest="verifySignature", default=False,
         help="Force verifying SWI signature if SWI is not blessed" )
   opts, args = op.parse_args( args )

   if len( args ) == 0:
      op.error( 'Please give me at least one swi file!' )

   for file in args:
      swivers( file )
      if SwiSignLib.swiSignatureExists( file ):
         blessed, _ = Swi.getBlessedAndVersion( file )
         if blessed or opts.verifySignature:
            _, verifySigMessage = SwiSignLib.verifySwiSignature( file )
            print verifySigMessage
         else:
            print "SWI is signed but not blessed. Use the --verify-signature" \
                  " option to force verification"
      else:
         print "%s is not signed." % file

if __name__ == "__main__":
   infoHandler()
