# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import argparse
import sys

from Swi import rpm

def freshenHandler( args=None ):
   if args is None:
      args = sys.argv[ 1: ]
   op = argparse.ArgumentParser(
         prog="swi freshen",
         description="Freshen RPMs in a SWI file with those built in this workspace",
         usage="usage: %(prog)s [--fast] [-o <file>] EOS.swi" )
   rpm.addRpmOptions( op )
   op.add_argument( 'SWI',
                    help='The image to freshen' )
   opts = op.parse_args( args )
   rpm.rpm( opts.SWI, opts, "-v", "-F", "/RPMS/*.rpm" )
