#!/usr/bin/env python
# Copyright (c) 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import zipfile
import subprocess
import optparse
import sys, os
import shutil

def extractRootfs( filename, opts=None ):
   assert filename.endswith( ".sqsh") or filename.endswith( ".gz" )
   
   if opts and opts.dirname:
      dirname = opts.dirname
   else:
      dirname = ".".join( filename.split( "." )[ :-1 ] ) + ".dir"

   if filename.endswith( ".sqsh" ):
      subprocess.check_call( [ "sudo", "unsquashfs", "-n", "-d", 
         dirname, filename ] )
   else:
      subprocess.check_call( [ "mkdir", "-p", dirname ] )
      shutil.move( filename, dirname )
      basename = os.path.basename( filename )
      curdir = os.path.abspath( os.curdir )
      os.chdir( dirname )
      subprocess.check_output( "gunzip -c {basename} | sudo cpio -ic".format( 
         basename=basename ), shell=True )
      os.remove( basename )
      os.chdir( curdir )

def extract( file, opts=None ):
   try:
      z = zipfile.ZipFile( os.path.abspath( file ) )
   except zipfile.BadZipfile:
      print "%s does not appear to be a swi image." % file
      return
   if opts and opts.dirname:
      dir = opts.dirname
      if os.path.exists( dir ) and not opts.use_existing:
         print "%s already exists and I don't have the guts to run rm -rf" % dir
         print "Please delete it so I don't have to."
         return
   else:
      dir = os.path.basename( file ).rsplit('.', 1)[0]
      if os.path.exists( dir ):
         print "%s already exists, use -d to specify extract directory." % dir
         return
   subprocess.check_call( [ "mkdir", "-p", dir ] )
   for f in z.namelist():
      subprocess.check_call( ["unzip", "-q", file, f, "-d", dir] )
      if f.startswith( "rootfs" ):
         extractRootfs( os.path.join( dir, f ) )

def extractHandler( args=sys.argv[1:] ):
   op = optparse.OptionParser(
         prog="swi extract",
         usage="usage: %prog EOS.swi" )
   op.add_option( '-d', '--dirname', action='store',
                  help='Directory in which to place the results')
   op.add_option( '-r', '--rootfs', action='store_true',
                  help='Extract a rootfs-formatted file instead of a full swi file' )
   op.add_option( '--use_existing', action='store_true',
                  help='Use existing directory to extract into' )
   opts, args = op.parse_args( args )

   if len( args ) != 1:
      op.error( 'Please give me exactly one swi file!' )
   if opts.rootfs:
      extractRootfs( args[0], opts )
   else:
      extract( args[0], opts )

if __name__ == "__main__":
   extractHandler()
