#!/usr/bin/env python
# Copyright (c) 2008, 2009 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# in autobuild sometimes SimpleConfigFile is not found
# pylint: disable-msg=F0401

import argparse
import glob
import os
import sys
import Swi
from Swi import sign
import SimpleConfigFile

_blessVersion = ''

SUCCESS = 0
BLESS_FAIL = 1

def bless( swiFile, skipSigning=False, blessVersion='' ):
   global _blessVersion
   if not _blessVersion:
      # This is just used for testing when we're calling bless by itself.
      # In normal execution we would call blessHandler which would set _blessVersion.
      _blessVersion = blessVersion
   Swi.inSwi( swiFile, [ blessWithinExtractedSwi ] )
   if not skipSigning:
      return sign.sign( swiFile, forceSign=True )
   return SUCCESS

def blessWithinExtractedSwi( swiDir ):
   swiVersion = glob.glob( os.path.join( swiDir, "rootfs-*.dir/etc/swi-version" ))[0]
   Swi.run( [ "sudo", "chmod", "666", swiVersion ] )
   config = SimpleConfigFile.SimpleConfigFileDict( swiVersion )
   if config.get( 'SWI_VERSION' ) != _blessVersion:
      print "\nERROR: SWI version (%s) and blessed version (%s) do not match." % (
         config.get( 'SWI_VERSION' ), _blessVersion ), "Please check the project " \
         "setting 'swiRelease' and set the correct value or get a successful build\n"
      sys.exit( BLESS_FAIL )
   if config.get('BLESSED'):
      print swiVersion, "already blessed"
   else:
      print "blessed", swiVersion
      config['BLESSED'] = 1
   Swi.run( [ "sudo", "chmod", "644", swiVersion ] )
   
def blessHandler( args=sys.argv[1:] ):
   global _blessVersion
   parser = argparse.ArgumentParser( prog="swi bless" )
   parser.add_argument( 'swi', metavar='EOS.swi',
                        help="Path of the SWI to be blessed" )
   parser.add_argument( 'version',
                        help="EOS release version the SWI has to be blessed for" )
   parser.add_argument( '--skip-signing',
                        help="Skip signing the SWI.", action="store_true" )

   args = parser.parse_args( args )
   if not args.version:
      parser.error( "Version is not specified. Typically, it's the value of "
                    "'swiRelease' project setting." )
   _blessVersion = args.version
   retCode = bless( args.swi, args.skip_signing, args.version )
   exit( retCode )
