# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import Tac
import SuperServer
import SslReactor

class SslManager( SuperServer.SuperServerAgent ):
   def __init__( self, entityManager ):
      SuperServer.SuperServerAgent.__init__( self, entityManager )
      self.warm_ = False
      mg = entityManager.mountGroup()
      self.config_ = mg.mount( 'mgmt/security/ssl/config',
                               'Mgmt::Security::Ssl::Config', 'r' )
      self.status_ = mg.mount( 'mgmt/security/ssl/status',
                               'Mgmt::Security::Ssl::Status', 'w' )
      self.execRequest_ = mg.mount( 'mgmt/security/ssl/execRequest',
                                    'Mgmt::Security::Ssl::ExecRequest', 'r')
      self.netStatus_ = mg.mount( Cell.path( 'sys/net/status' ),
                                  'System::NetStatus', 'r' )
      def _finished():
         # run only if active
         if self.active():
            self.onSwitchover( None )
      mg.close( _finished )

   def onSwitchover( self, protocol ):
      SslReactor.SslReactor( self.config_, self.status_,
                             self.execRequest_, self.netStatus_ )
      self.warm_ = True
   
   def warm( self ):
      if not self.active():
         return True
      return self.warm_
   
def Plugin( context ):
   context.registerService( SslManager( context.entityManager ) )
