# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from OvsdbServerBase import OvsdbConfigNotifieeBase, OvsdbServerBase
import Tracing, QuickTrace
import Tac

t1 = Tracing.trace1
__defaultTraceHandle__ = Tracing.Handle( 'HscOvsdb' )
qt1 = QuickTrace.trace1

cliDefaults = Tac.Value( 'Hsc::CliDefaults' )

# This is the OVSDB SuperServerPlugin that is used in physical DUTs.  It starts OVSDB
# as a Linux service that persists beyond SuperServer restarts.  It is mutually
# exclusive with the TestOvsdbServer SuperServerPlugin.

class OvsdbConfigNotifiee( OvsdbConfigNotifieeBase ):
   def __init__( self, serviceName, hscConfig, hscCliConfig, hscStatus,
                 sslConfig, sslStatus, cvxConfig, cvxStatus,
                 fileRepStatus, clusterStatusDir, haFiles, active=True ):
      t1( "OvsdbConfigNotifiee" )
      OvsdbConfigNotifieeBase.__init__( self, serviceName, hscConfig, hscCliConfig,
                                        hscStatus, sslConfig, sslStatus,
                                        cvxConfig, cvxStatus, fileRepStatus,
                                        clusterStatusDir, haFiles, active=active )

   def addExtraOvsdbOptions( self ):
      self.options += [ '--detach', '--monitor' ]

      if self.cliConfig.passiveTcpPort != cliDefaults.passiveTcpPort:
         t1( 'Adding remote ptcp port:%s' % ( self.cliConfig.passiveTcpPort ) )
         # add this option only if user has specified a port through cli
         self.options += [ '--remote=ptcp:%s' % ( self.cliConfig.passiveTcpPort ) ]

   def startOvsdb( self ):
      t1( 'Starting OVSDB via _runServiceCmd' )
      qt1( 'Hsc:: Ovsdb is starting' )
      self._runServiceCmd( 'start' )
      t1( 'Ovsdb is started' )
      self.ovsdbStarted = True

   def stopOvsdb( self ):
      t1( "Ovsdb is stopping" )
      qt1( "Hsc:: Ovsdb is stopping" )
      self.ovsdbStarted = False
      t1( 'Stopping service via _runServiceCmd' )
      self._runServiceCmd( 'stop' )

class OvsdbServer( OvsdbServerBase ):
   def __init__( self, entityManager ):
      t1( "OvsdbServer" )
      OvsdbServerBase.__init__( self, entityManager )

   def createOvsdbConfigNotifiee( self, hscConfig, hscCliConfig, hscStatus,
                                  sslConfig, sslStatus,
                                  cvxConfig, cvxStatus, fileRepStatus,
                                  clusterStatusDir, haFiles ):
      return OvsdbConfigNotifiee( "OvsdbServer", hscConfig, hscCliConfig,
                                  hscStatus, sslConfig, sslStatus,
                                  cvxConfig, cvxStatus, fileRepStatus,
                                  clusterStatusDir, haFiles, active=self.active() )

def Plugin( ctx ):
   ctx.registerService( OvsdbServer( ctx.entityManager ) )
