#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os, sys

def stableFilePath( bridgeName ):
   return "/var/run/StpStable%s" % bridgeName

def stableFileExists( bridgeName ):
   path = stableFilePath( bridgeName )
   return os.path.isfile( path )

def removeStableFile( bridgeName ):
   path = stableFilePath( bridgeName )
   try:
      os.remove( path )
   except OSError:
      # It's ok if we failed to remove the file (already gone)
      pass

def createStableFile( bridgeName ):
   path = stableFilePath( bridgeName )
   try:
      if not os.path.exists( path ):
         open( path, 'w' ).close() 
   except OSError:
      print "FAIL: Unable to write %s. Exiting." % path
      sys.exit( 1 )

def stableControlStatusTypename():
   return "Stp::StableControlStatus"
