#!/usr/bin/env python
# Copyright (c) 2007, 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

# Bridge priority, lower numerical value has higher priority. Allowed values
# are 0-61440, in steps of 4096.
BridgePriority = Tac.Type( 'Stp::BridgePriority' )
BridgePriorityMin = BridgePriority.minBridgePriority
BridgePriorityMax = BridgePriority.maxBridgePriority
BridgePriorityDefault = BridgePriority.defaultBridgePriority
BridgePriorityPrimary = BridgePriority.primaryBridgePriority
BridgePrioritySecondary = BridgePriority.secondaryBridgePriority
BridgePriorityStepSize = 4096
BridgePrioritySuper = BridgePriorityMin

# Port priority, valid values are 0-240, in steps of 16.
PortPriority = Tac.Type( 'Stp::PortPriority' )
PortPriorityMin = PortPriority.minPortPriority
PortPriorityMax = PortPriority.maxPortPriority
PortPriorityDefault = PortPriority.defaultPortPriority
PortPriorityUnconfigured = PortPriority.invalidConfigurablePortPriority
PortPriorityStepSize = 16

# Port path cost
PathCost = Tac.Type( 'Stp::PathCost' )
PathCostUnknown = PathCost.invalidConfigurablePathCost # When it's not configured
PathCostDefault = PathCost.minConfigurablePathCost
PathCostMin = PathCost.minConfigurablePathCost
PathCostMax = PathCost.maxConfigurablePathCost

# Allowed ranges for various Stp::Config attributes

StpConfigBase = Tac.Type( 'Stp::ConfigBase' )
ForwardDelayMin = StpConfigBase.minBridgeForwardDelay
ForwardDelayMax = StpConfigBase.maxBridgeForwardDelay

HelloTimeMin = StpConfigBase.minBridgeHelloTime
HelloTimeMax = StpConfigBase.maxBridgeHelloTime

MaxAgeMin = StpConfigBase.maxAgeLow
MaxAgeMax = StpConfigBase.maxAgeHigh

MaxHopsMin = StpConfigBase.maxHopsLow
MaxHopsMax = StpConfigBase.maxHopsHigh

StpPortConfig = Tac.Type( 'Stp::PortConfig' )
PortHelloTimeMin = StpPortConfig.minPortHelloTime
PortHelloTimeMax = StpPortConfig.maxPortHelloTime
PortHelloTimeDefault = StpPortConfig.defaultPortHelloTime

TxHoldCountMin = StpConfigBase.minTxHoldCount
TxHoldCountMax = StpConfigBase.maxTxHoldCount

InstanceId = Tac.Type( 'Stp::InstanceId' )
MstInstIdMin = InstanceId.minInstanceId
MstInstIdMax = InstanceId.maxInstanceId
MstCistInstId = InstanceId.minInstanceId

# The standard says we can have at most 64 msti instances plus the cist at any
# given time.
MstInstCountMax = 64

MstConfigSpec = Tac.Type( 'Stp::MstConfigSpec' )
MstRevisionMin = MstConfigSpec.minConfigRevision
MstRevisionMax = MstConfigSpec.maxConfigRevision
MstRevisionDefault = MstRevisionMin

VlanId = Tac.Type( 'Bridging::VlanId' )
ValidVlanIdMin = VlanId.min
ValidVlanIdMax = VlanId.max

AdminEdgePortDefault = False

AutoEdgePortDefault = True

NetworkPortDefault= False

StpConst = Tac.Type( 'Stp::Constants' )
SuperRootMacAddr = StpConst.superRootMacAddr
