# Copyright (c) 2006-2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell, Tracing, Tac

traceHandle = Tracing.defaultTraceHandle()
t0 = traceHandle.trace0

_redundancyConfigPlugin = None

class RedundancyConfigReactor( Tac.Notifiee ):
   notifierTypeName = 'Redundancy::RedundancyConfig'

   def __init__( self, notifier, stageConfig ):
      Tac.Notifiee.__init__( self, notifier )
      self.sc_ = stageConfig
      self.handleGlobalStageCompletionTimeout()
      
   @Tac.handler( 'globalStageCompletionTimeout' )
   def handleGlobalStageCompletionTimeout( self ):
      # set sso completion timeout
      # globalStageCompletionTimeout value will be passed from
      # redundancyConfig to stageConfig
      self.sc_.globalStageCompletionTimeout = \
         self.notifier_.globalStageCompletionTimeout

class RedundancyConfigPlugin( object ):
   def __init__( self, entityManager ):
      mg = entityManager.mountGroup()
      self.redundancyConfig_ = mg.mount( 'redundancy/config',
                                         'Redundancy::RedundancyConfig', 'r' )
      self.stageConfig_ = mg.mount( Cell.path( 'stage/switchover/config/config' ),
                                    'Stage::Config', 'wf' )
      self.redundancyConfigReactor_ = None

      def _finishMounts():
         self.redundancyConfigReactor_ = \
            RedundancyConfigReactor( self.redundancyConfig_, self.stageConfig_ )  
  
      mg.close( _finishMounts )

#--------------------------------------------------
# Plugin method - Mount the objects we need from Sysdb
#-------------------------------------------------- 
def Plugin( entityManager ):
   t0( 'Loading RedSup BootMgrPlugin' )
   global _redundancyConfigPlugin
   _redundancyConfigPlugin = RedundancyConfigPlugin( entityManager )
