#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import StageSysdbHelper
# pkgdeps: import AsuUtil
from StageGraph.AsuFastBootStrata import registerAsuFastBootStrata
from StageGraph.AsuHitlessBootSand import registerAsuHitlessBootSand
from StageGraph.AsuHitlessBootStrata import registerAsuHitlessBootStrata
from StageGraph.AsuHitlessBootBarefoot import registerAsuHitlessBootBarefoot
from StageGraph.AsuShutdown import registerAsuShutdown
from StageGraph.MaintEnter import registerMaintEnter
from StageGraph.MaintExit import registerMaintExit
from StageGraph.NormalBoot import registerNormalBoot
from StageGraph.NormalBootXp import registerNormalBootXp
from StageGraph.SupervisorColdBoot import registerSupervisorColdBoot
from StageGraph.Switchover import registerSwitchover
from StageGraphUtil import BootModeConfig
from StageGraphUtil import getPlatformType

traceHandle = Tracing.Handle( 'StageGraphs' )
t0 = traceHandle.trace0

# register the stage graphs used for various boot modes
def registerBoot( entMan ):

   sh = StageSysdbHelper.StageHelper( entMan, 'boot' )
   sh.registerStageClass()
   bootModeConfig = BootModeConfig( entMan )
   bootModeConfig.bootModeStagesIs( "normalBoot", registerNormalBoot )
   bootModeConfig.bootModeStagesIs( "normalBootXp", registerNormalBootXp )
   bootModeConfig.bootModeStagesIs( "supervisorColdBoot", registerSupervisorColdBoot
         )

   platform = getPlatformType()
   t0( "registerBoot platform:", platform )
   
   if platform == "sand":
      bootModeConfig.bootModeStagesIs( "asuFastBoot", registerNormalBoot )
      bootModeConfig.bootModeStagesIs( "asuHitlessBoot", registerAsuHitlessBootSand )
   elif platform == "barefoot":
      bootModeConfig.bootModeStagesIs( "asuFastBoot", registerNormalBoot )
      bootModeConfig.bootModeStagesIs( "asuHitlessBoot", 
                                       registerAsuHitlessBootBarefoot )
   else:
      bootModeConfig.bootModeStagesIs( "asuFastBoot", registerAsuFastBootStrata )
      bootModeConfig.bootModeStagesIs( "asuHitlessBoot", 
                                       registerAsuHitlessBootStrata )

   sh.initializedIs( True )

# register stage graph used for ASU shutdown
def registerShutdown( entMan ):
   sh = StageSysdbHelper.StageHelper( entMan, 'shutdown' )
   sh.registerStageClass()

   registerAsuShutdown( entMan )
   sh.initializedIs( True )

def registerStageGraphs( entMan ):
   registerBoot( entMan )
   registerShutdown( entMan )
   registerSwitchover( entMan )

   registerMaintEnter( entMan )
   registerMaintExit( entMan )
